/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.MutableDirectBuffer;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionId;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MessageHeaderEncoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.ProfilesEncoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfile;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfiles;

class SubscriptionProfilesEncoder {
    private final SubscriptionIds subscriptionIds;
    private final MutableDirectBuffer buffer;

    SubscriptionProfilesEncoder(SubscriptionIds subscriptionIds, int bufferSize) {
        this.subscriptionIds = subscriptionIds;
        this.buffer = new ExpandableDirectByteBuffer(bufferSize);
    }

    byte[] encode(SubscriptionProfiles profiles) {
        Map<SubscriptionId, SubscriptionProfile> subscriptionProfiles = this.mapToSubscriptionIds(profiles);
        MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
        ProfilesEncoder body = new ProfilesEncoder().wrapAndApplyHeader(this.buffer, 0, headerEncoder);
        ProfilesEncoder.SubscriptionsEncoder subscriptionsEncoder = body.updateTimestamp(this.toMillis(profiles.getUpdateTimestamp())).subscriptionsCount(subscriptionProfiles.size());
        for (Map.Entry<SubscriptionId, SubscriptionProfile> entry : subscriptionProfiles.entrySet()) {
            SubscriptionId subscriptionId = entry.getKey();
            SubscriptionProfile profile = entry.getValue();
            subscriptionsEncoder.next().id(subscriptionId.getValue()).operationsPerSecond(profile.getWeight().getOperationsPerSecond()).lastRebalanceTimestamp(this.toMillis(profile.getLastRebalanceTimestamp()));
        }
        int len = headerEncoder.encodedLength() + body.encodedLength();
        byte[] dst = new byte[len];
        this.buffer.getBytes(0, dst);
        return dst;
    }

    private Map<SubscriptionId, SubscriptionProfile> mapToSubscriptionIds(SubscriptionProfiles profiles) {
        HashMap<SubscriptionId, SubscriptionProfile> subscriptionProfiles = new HashMap<SubscriptionId, SubscriptionProfile>();
        for (SubscriptionName subscriptionName : profiles.getSubscriptions()) {
            Optional<SubscriptionId> subscriptionId = this.subscriptionIds.getSubscriptionId(subscriptionName);
            subscriptionId.ifPresent(id -> subscriptionProfiles.put((SubscriptionId)id, profiles.getProfile(subscriptionName)));
        }
        return subscriptionProfiles;
    }

    private long toMillis(Instant timestamp) {
        if (timestamp == Instant.MIN) {
            return -1L;
        }
        return timestamp.toEpochMilli();
    }
}

