/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNode;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;

public class WeightedWorkloadMetrics {
    private static final String METRICS_PREFIX = "consumer-workload.weighted.";
    private static final String CONSUMER_ID_PLACEHOLDER = "$consumerId";
    private static final String CURRENT_SCORE = "consumer-workload.weighted.$consumerId.current-score";
    private static final String PROPOSED_SCORE = "consumer-workload.weighted.$consumerId.proposed-score";
    private static final String SCORING_ERROR = "consumer-workload.weighted.$consumerId.error";
    private static final String CURRENT_WEIGHT_OPS = "consumer-workload.weighted.$consumerId.current-weight.ops";
    private static final String PROPOSED_WEIGHT_OPS = "consumer-workload.weighted.$consumerId.proposed-weight.ops";
    private final HermesMetrics metrics;
    private final Map<String, Double> currentWeights = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> proposedWeights = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> currentScores = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> proposedScores = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> scoringErrors = new ConcurrentHashMap<String, Double>();

    public WeightedWorkloadMetrics(HermesMetrics metrics) {
        this.metrics = metrics;
    }

    void reportCurrentScore(String consumerId, double score) {
        this.registerGaugeIfNeeded(this.currentScores, consumerId, CURRENT_SCORE);
        this.currentScores.put(consumerId, score);
    }

    void reportProposedScore(String consumerId, double score) {
        this.registerGaugeIfNeeded(this.proposedScores, consumerId, PROPOSED_SCORE);
        this.proposedScores.put(consumerId, score);
    }

    void reportScoringError(String consumerId, double error) {
        this.registerGaugeIfNeeded(this.scoringErrors, consumerId, SCORING_ERROR);
        this.scoringErrors.put(consumerId, error);
    }

    void reportCurrentWeights(Collection<ConsumerNode> consumers) {
        for (ConsumerNode consumerNode : consumers) {
            String consumerId = consumerNode.getConsumerId();
            this.registerGaugeIfNeeded(this.currentWeights, consumerId, CURRENT_WEIGHT_OPS);
            this.currentWeights.put(consumerId, consumerNode.getWeight().getOperationsPerSecond());
        }
    }

    void reportProposedWeights(Map<String, Weight> newWeights) {
        for (Map.Entry<String, Weight> entry : newWeights.entrySet()) {
            String consumerId = entry.getKey();
            this.registerGaugeIfNeeded(this.proposedWeights, consumerId, PROPOSED_WEIGHT_OPS);
            this.proposedWeights.put(consumerId, entry.getValue().getOperationsPerSecond());
        }
    }

    private void registerGaugeIfNeeded(Map<String, Double> currentValues, String consumerId, String metric) {
        if (!currentValues.containsKey(consumerId)) {
            String metricPath = this.buildFullMetricPath(metric, consumerId);
            this.metrics.registerGauge(metricPath, () -> currentValues.getOrDefault(consumerId, 0.0));
        }
    }

    void unregisterLeaderMetrics() {
        this.unregisterMetricsForConsumersOtherThan(Collections.emptySet());
    }

    void unregisterMetricsForConsumersOtherThan(Set<String> consumerIds) {
        this.unregisterGaugesForConsumersOtherThan(this.currentWeights, consumerIds, CURRENT_WEIGHT_OPS);
        this.unregisterGaugesForConsumersOtherThan(this.proposedWeights, consumerIds, PROPOSED_WEIGHT_OPS);
        this.unregisterGaugesForConsumersOtherThan(this.currentScores, consumerIds, CURRENT_SCORE);
        this.unregisterGaugesForConsumersOtherThan(this.proposedScores, consumerIds, PROPOSED_SCORE);
        this.unregisterGaugesForConsumersOtherThan(this.scoringErrors, consumerIds, SCORING_ERROR);
    }

    private void unregisterGaugesForConsumersOtherThan(Map<String, Double> currentValues, Set<String> consumerIds, String metric) {
        Set consumerIdsToRemove = currentValues.keySet().stream().filter(consumerId -> !consumerIds.contains(consumerId)).collect(Collectors.toSet());
        for (String consumerId2 : consumerIdsToRemove) {
            if (consumerIds.contains(consumerId2)) continue;
            String metricPath = this.buildFullMetricPath(metric, consumerId2);
            this.metrics.unregister(metricPath);
            currentValues.remove(consumerId2);
        }
    }

    private String buildFullMetricPath(String metric, String consumerId) {
        return metric.replace(CONSUMER_ID_PLACEHOLDER, HermesMetrics.escapeDots((String)consumerId));
    }
}

