/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfileRegistry;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfiles;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfilesDecoder;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfilesEncoder;
import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

public class ZookeeperSubscriptionProfileRegistry
implements SubscriptionProfileRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperSubscriptionProfileRegistry.class);
    private final CuratorFramework curator;
    private final SubscriptionProfilesEncoder encoder;
    private final SubscriptionProfilesDecoder decoder;
    private final String profilesPath;

    public ZookeeperSubscriptionProfileRegistry(CuratorFramework curator, SubscriptionIds subscriptionIds, ZookeeperPaths zookeeperPaths, String clusterName, int subscriptionProfilesEncoderBufferSizeBytes) {
        this.curator = curator;
        this.encoder = new SubscriptionProfilesEncoder(subscriptionIds, subscriptionProfilesEncoderBufferSizeBytes);
        this.decoder = new SubscriptionProfilesDecoder(subscriptionIds);
        this.profilesPath = zookeeperPaths.join(new String[]{zookeeperPaths.basePath(), "consumers-workload", clusterName, "subscription-profiles"});
    }

    @Override
    public SubscriptionProfiles fetch() {
        try {
            if (this.curator.checkExists().forPath(this.profilesPath) != null) {
                byte[] bytes = (byte[])this.curator.getData().forPath(this.profilesPath);
                return this.decoder.decode(bytes);
            }
        }
        catch (Exception e) {
            logger.warn("Could not read node data on path " + this.profilesPath, (Throwable)e);
        }
        return SubscriptionProfiles.EMPTY;
    }

    @Override
    public void persist(SubscriptionProfiles profiles) {
        byte[] encoded = this.encoder.encode(profiles);
        try {
            this.updateOrCreate(encoded);
        }
        catch (Exception e) {
            logger.error("An error while saving subscription profiles", (Throwable)e);
        }
    }

    private void updateOrCreate(byte[] encoded) throws Exception {
        try {
            this.curator.setData().forPath(this.profilesPath, encoded);
        }
        catch (KeeperException.NoNodeException e) {
            try {
                ((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentContainersIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.profilesPath, encoded);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
        }
    }
}

