/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.config;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import pl.allegro.tech.hermes.common.util.InetAddressInstanceIdResolver;
import pl.allegro.tech.hermes.consumers.consumer.receiver.kafka.KafkaReceiverParameters;

@ConfigurationProperties(prefix="consumer.receiver")
public class ConsumerReceiverProperties
implements KafkaReceiverParameters {
    private Duration poolTimeout = Duration.ofMillis(30L);
    private int readQueueCapacity = 1000;
    private boolean waitBetweenUnsuccessfulPolls = true;
    private Duration initialIdleTime = Duration.ofMillis(10L);
    private Duration maxIdleTime = Duration.ofMillis(1000L);
    private String clientId = new InetAddressInstanceIdResolver().resolve();
    private boolean filteringRateLimiterEnabled = true;
    private boolean filteringEnabled = true;

    @Override
    public Duration getPoolTimeout() {
        return this.poolTimeout;
    }

    public void setPoolTimeout(Duration poolTimeout) {
        this.poolTimeout = poolTimeout;
    }

    @Override
    public int getReadQueueCapacity() {
        return this.readQueueCapacity;
    }

    public void setReadQueueCapacity(int readQueueCapacity) {
        this.readQueueCapacity = readQueueCapacity;
    }

    @Override
    public boolean isWaitBetweenUnsuccessfulPolls() {
        return this.waitBetweenUnsuccessfulPolls;
    }

    public void setWaitBetweenUnsuccessfulPolls(boolean waitBetweenUnsuccessfulPolls) {
        this.waitBetweenUnsuccessfulPolls = waitBetweenUnsuccessfulPolls;
    }

    @Override
    public Duration getInitialIdleTime() {
        return this.initialIdleTime;
    }

    public void setInitialIdleTime(Duration initialIdleTime) {
        this.initialIdleTime = initialIdleTime;
    }

    @Override
    public Duration getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(Duration maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public boolean isFilteringRateLimiterEnabled() {
        return this.filteringRateLimiterEnabled;
    }

    public void setFilteringRateLimiterEnabled(boolean filteringRateLimiterEnabled) {
        this.filteringRateLimiterEnabled = filteringRateLimiterEnabled;
    }

    @Override
    public boolean isFilteringEnabled() {
        return this.filteringEnabled;
    }

    public void setFilteringEnabled(boolean filteringEnabled) {
        this.filteringEnabled = filteringEnabled;
    }
}

