/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSenderFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.BatchHttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.JettyMessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.DefaultBatchHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.SimpleEndpointAddressResolver;

public class HttpMessageBatchSenderFactory
implements MessageBatchSenderFactory {
    private final SendingResultHandlers resultHandlers;
    private final BatchHttpRequestFactory batchHttpRequestFactory;

    public HttpMessageBatchSenderFactory(SendingResultHandlers resultHandlers, BatchHttpRequestFactory batchHttpRequestFactory) {
        this.resultHandlers = resultHandlers;
        this.batchHttpRequestFactory = batchHttpRequestFactory;
    }

    @Override
    public MessageBatchSender create(Subscription subscription) {
        Preconditions.checkState((boolean)subscription.getEndpoint().getProtocol().contains("http"), (Object)"Batching is only supported for http/s currently.");
        return new JettyMessageBatchSender(this.batchHttpRequestFactory, new SimpleEndpointAddressResolver(), this.resultHandlers, new DefaultBatchHeadersProvider());
    }
}

