/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import pl.allegro.tech.hermes.infrastructure.zookeeper.ZookeeperPaths;

class MaxRateRegistryPaths {
    private static final String RATE_RUNTIME_PATH = "runtime-bin";
    private final ZookeeperPaths zookeeperPaths;
    private final String clusterName;
    private final String currentConsumerRateHistoryPath;

    MaxRateRegistryPaths(ZookeeperPaths zookeeperPaths, String currentConsumerId, String clusterName) {
        this.zookeeperPaths = zookeeperPaths;
        this.clusterName = clusterName;
        this.currentConsumerRateHistoryPath = this.consumerRateHistoryPath(currentConsumerId);
    }

    String consumerMaxRatePath(String consumerId) {
        return this.zookeeperPaths.join(new String[]{this.consumerRateParentRuntimePath(consumerId), "max-rate"});
    }

    String consumerRateHistoryPath(String consumerId) {
        return this.zookeeperPaths.join(new String[]{this.consumerRateParentRuntimePath(consumerId), "history"});
    }

    String consumerRateParentRuntimePath(String consumerId) {
        return this.zookeeperPaths.join(new String[]{this.consumersRateCurrentClusterRuntimeBinaryPath(), consumerId});
    }

    String consumersRateCurrentClusterRuntimeBinaryPath() {
        return this.zookeeperPaths.join(new String[]{this.zookeeperPaths.basePath(), "consumers-rate", this.clusterName, RATE_RUNTIME_PATH});
    }

    String currentConsumerRateHistoryPath() {
        return this.currentConsumerRateHistoryPath;
    }
}

