/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.receiver.kafka;

import com.google.common.primitives.Ints;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import pl.allegro.tech.hermes.consumers.config.KafkaHeaderNameProperties;

public class KafkaHeaderExtractor {
    private final KafkaHeaderNameProperties kafkaHeaderNameProperties;

    public KafkaHeaderExtractor(KafkaHeaderNameProperties kafkaHeaderNameProperties) {
        this.kafkaHeaderNameProperties = kafkaHeaderNameProperties;
    }

    public Integer extractSchemaVersion(Headers headers) {
        Header header = headers.lastHeader(this.kafkaHeaderNameProperties.getSchemaVersion());
        return this.extract(header);
    }

    public Integer extractSchemaId(Headers headers) {
        Header header = headers.lastHeader(this.kafkaHeaderNameProperties.getSchemaId());
        return this.extract(header);
    }

    private Integer extract(Header header) {
        if (header != null) {
            return Ints.fromByteArray((byte[])header.value());
        }
        return null;
    }

    public String extractMessageId(Headers headers) {
        Header header = headers.lastHeader(this.kafkaHeaderNameProperties.getMessageId());
        if (header == null) {
            return "";
        }
        return new String(header.value(), StandardCharsets.UTF_8);
    }
}

