/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Timer;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.tracker.consumers.MessageMetadata;

public class SubscriptionMetrics {
    private final HermesMetrics metrics;
    private final SubscriptionName subscription;

    public SubscriptionMetrics(HermesMetrics metrics, SubscriptionName subscription) {
        this.metrics = metrics;
        this.subscription = subscription;
    }

    public void markAttempt() {
        this.metrics.incrementInflightCounter(this.subscription);
    }

    public void markSuccess(MessageBatch batch, MessageSendingResult result) {
        this.metrics.meter("meter").mark((long)batch.size());
        this.metrics.meter("meter.$group.$topic", this.subscription.getTopicName()).mark((long)batch.size());
        this.metrics.meter("meter.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark((long)batch.size());
        this.metrics.meter("meter.$group.$topic.$subscription.batch", this.subscription.getTopicName(), this.subscription.getName()).mark();
        this.metrics.meter("throughput.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark((long)batch.getCapacity());
        this.metrics.registerConsumerHttpAnswer(this.subscription, result.getStatusCode());
        this.metrics.counter("delivered.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).inc((long)batch.size());
        this.metrics.decrementInflightCounter(this.subscription, batch.size());
        this.metrics.inflightTimeHistogram(this.subscription).update(batch.getLifetime());
    }

    public void markSuccess(Message message, MessageSendingResult result) {
        this.metrics.meter("meter").mark();
        this.metrics.meter("meter.$group.$topic", this.subscription.getTopicName()).mark();
        this.metrics.meter("meter.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark();
        this.metrics.meter("throughput.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark(message.getSize());
        this.metrics.registerConsumerHttpAnswer(this.subscription, result.getStatusCode());
        this.metrics.counter("delivered.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).inc();
        this.metrics.decrementInflightCounter(this.subscription);
        this.metrics.inflightTimeHistogram(this.subscription).update(System.currentTimeMillis() - message.getReadingTimestamp());
    }

    public void markFailure(MessageBatch batch, MessageSendingResult result) {
        this.registerFailureMetrics(result, batch.getCapacity());
    }

    public void markFailure(Message message, MessageSendingResult result) {
        this.registerFailureMetrics(result, message.getSize());
    }

    private void registerFailureMetrics(MessageSendingResult result, long messageSize) {
        this.metrics.meter("failed-meter.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark();
        if (result.hasHttpAnswer()) {
            this.metrics.registerConsumerHttpAnswer(this.subscription, result.getStatusCode());
        } else if (result.isTimeout()) {
            this.metrics.consumerErrorsTimeoutMeter(this.subscription).mark();
        } else {
            this.metrics.consumerErrorsOtherMeter(this.subscription).mark();
        }
        this.metrics.meter("throughput.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark(messageSize);
    }

    public void markDiscarded(Message message) {
        this.metrics.meter("discarded-meter").mark();
        this.metrics.meter("discarded-meter.$group.$topic", this.subscription.getTopicName()).mark();
        this.metrics.meter("discarded-meter.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark();
        this.metrics.counter("discarded.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).inc();
        this.metrics.decrementInflightCounter(this.subscription);
        this.metrics.inflightTimeHistogram(this.subscription).update(System.currentTimeMillis() - message.getReadingTimestamp());
    }

    public void markDiscarded(MessageBatch batch) {
        this.metrics.meter("discarded-meter").mark((long)batch.size());
        this.metrics.meter("discarded-meter.$group.$topic", this.subscription.getTopicName()).mark((long)batch.size());
        this.metrics.meter("discarded-meter.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).mark((long)batch.size());
        this.metrics.counter("discarded.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName()).inc((long)batch.size());
        this.metrics.decrementInflightCounter(this.subscription, batch.size());
        this.metrics.inflightTimeHistogram(this.subscription).update(batch.getLifetime());
    }

    public void markDiscarded(MessageMetadata messageMetadata) {
        TopicName topicName = TopicName.fromQualifiedName((String)messageMetadata.getTopic());
        this.metrics.counter("discarded.$group.$topic.$subscription", topicName, messageMetadata.getSubscription()).inc();
        this.metrics.meter("discarded-meter").mark();
        this.metrics.meter("discarded-meter.$group.$topic", topicName).mark();
        this.metrics.meter("discarded-meter.$group.$topic.$subscription", topicName, messageMetadata.getSubscription()).mark();
        this.metrics.decrementInflightCounter(this.subscription);
    }

    public Timer subscriptionLatencyTimer() {
        return this.metrics.timer("latency.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName());
    }

    public void markFilteredOut() {
        this.metrics.meter("meter.$group.$topic.$subscription.filtered", this.subscription.getTopicName(), this.subscription.getName()).mark();
    }

    public Timer consumerIdleTimer() {
        return this.metrics.timer("idle-time.$group.$topic.$subscription", this.subscription.getTopicName(), this.subscription.getName());
    }

    public Counter rateHistoryFailuresCounter() {
        return this.metrics.counter("consumers-rate.max-rate.node.$group.$topic.$subscription.history.failures", this.subscription.getTopicName(), this.subscription.getName());
    }

    public Counter maxRateFetchFailuresCounter() {
        return this.metrics.counter("consumers-rate.max-rate.node.$group.$topic.$subscription.fetch.failures", this.subscription.getTopicName(), this.subscription.getName());
    }

    public void registerMaxRateGauge(Gauge<Double> gauge) {
        this.metrics.registerGauge("consumers-rate.max-rate.node.$group.$topic.$subscription.max-rate", this.subscription, gauge);
    }

    public void registerRateGauge(Gauge<Double> gauge) {
        this.metrics.registerGauge("consumers-rate.max-rate.node.$group.$topic.$subscription.rate", this.subscription, gauge);
    }

    public void registerOutputRateGauge(Gauge<Double> gauge) {
        this.metrics.registerGauge("output-rate.$group.$topic.$subscription", this.subscription, gauge);
    }

    public void shutdown() {
        this.metrics.unregister("discarded-meter.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("failed-meter.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("meter.$group.$topic.$subscription.batch", this.subscription);
        this.metrics.unregister("meter.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("delivered.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("discarded.$group.$topic.$subscription", this.subscription);
        this.metrics.unregisterInflightCounter(this.subscription);
        this.metrics.unregisterInflightTimeHistogram(this.subscription);
        this.metrics.unregisterConsumerErrorsTimeoutMeter(this.subscription);
        this.metrics.unregisterConsumerErrorsOtherMeter(this.subscription);
        this.metrics.unregisterStatusMeters(this.subscription);
        this.metrics.unregister("output-rate.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("consumers-rate.max-rate.node.$group.$topic.$subscription.rate", this.subscription);
        this.metrics.unregister("consumers-rate.max-rate.node.$group.$topic.$subscription.max-rate", this.subscription);
        this.metrics.unregister("consumers-rate.max-rate.node.$group.$topic.$subscription.fetch.failures", this.subscription);
        this.metrics.unregister("consumers-rate.max-rate.node.$group.$topic.$subscription.history.failures", this.subscription);
        this.metrics.unregister("idle-time.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("meter.$group.$topic.$subscription.filtered", this.subscription);
        this.metrics.unregister("latency.$group.$topic.$subscription", this.subscription);
        this.metrics.unregister("throughput.$group.$topic.$subscription", this.subscription);
    }
}

