/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.queue;

import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.MpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.consumers.queue.MpscQueue;

public class FullDrainMpscQueue<T>
implements MpscQueue<T> {
    private static final Logger logger = LoggerFactory.getLogger(FullDrainMpscQueue.class);
    private final MpscArrayQueue<T> queue;

    public FullDrainMpscQueue(int capacity) {
        this.queue = new MpscArrayQueue(capacity);
    }

    @Override
    public boolean offer(T element) {
        return this.queue.offer(element);
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<T> consumer) {
        int size = this.queue.size();
        for (int i = 0; i < size; ++i) {
            Object element = this.queue.poll();
            if (element == null) {
                logger.warn("Unexpected null value while draining queue [idx={}, size={}]", (Object)i, (Object)size);
                break;
            }
            consumer.accept(element);
        }
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public int capacity() {
        return this.queue.capacity();
    }
}

