/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateBalancer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateCalculator;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.registry.ConsumerNodesRegistry;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ClusterAssignmentCache;

class MaxRateCalculatorJob
implements LeaderLatchListener,
Runnable {
    private final Duration interval;
    private final ScheduledExecutorService executorService;
    private final MaxRateCalculator maxRateCalculator;
    private final ConsumerNodesRegistry consumerNodesRegistry;
    private ScheduledFuture<?> job;

    MaxRateCalculatorJob(Duration internal, ClusterAssignmentCache clusterAssignmentCache, ConsumerNodesRegistry consumerNodesRegistry, MaxRateBalancer balancer, MaxRateRegistry maxRateRegistry, SubscriptionsCache subscriptionsCache, HermesMetrics metrics, Clock clock) {
        this.consumerNodesRegistry = consumerNodesRegistry;
        this.interval = internal;
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("max-rate-calculator-%d").build());
        this.maxRateCalculator = new MaxRateCalculator(clusterAssignmentCache, subscriptionsCache, balancer, maxRateRegistry, metrics, clock);
    }

    public void start() {
        this.consumerNodesRegistry.addLeaderLatchListener(this);
        this.startJobIfAlreadyBeingLeader();
    }

    private void startJobIfAlreadyBeingLeader() {
        if (this.consumerNodesRegistry.isLeader()) {
            this.isLeader();
        }
    }

    public void stop() throws InterruptedException {
        this.consumerNodesRegistry.removeLeaderLatchListener(this);
        if (this.job != null) {
            this.job.cancel(false);
        }
        this.executorService.shutdown();
        this.executorService.awaitTermination(1L, TimeUnit.MINUTES);
    }

    @Override
    public void run() {
        if (this.consumerNodesRegistry.isLeader()) {
            this.maxRateCalculator.calculate();
        }
    }

    public void isLeader() {
        this.job = this.executorService.scheduleAtFixedRate(this, this.interval.toSeconds(), this.interval.toSeconds(), TimeUnit.SECONDS);
    }

    public void notLeader() {
        this.job.cancel(false);
    }
}

