/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.CompletableFutureAwareMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubClient;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubClientsPool;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubSenderTarget;

class GooglePubSubMessageSender
implements CompletableFutureAwareMessageSender {
    private final GooglePubSubClient googlePubSubClient;
    private final GooglePubSubSenderTarget resolvedTarget;
    private final GooglePubSubClientsPool clientsPool;

    GooglePubSubMessageSender(GooglePubSubSenderTarget resolvedTarget, GooglePubSubClientsPool clientsPool) throws IOException {
        this.googlePubSubClient = clientsPool.acquire(resolvedTarget);
        this.resolvedTarget = resolvedTarget;
        this.clientsPool = clientsPool;
    }

    @Override
    public void send(Message message, CompletableFuture<MessageSendingResult> resultFuture) {
        try {
            this.googlePubSubClient.publish(message, resultFuture);
        }
        catch (IOException | InterruptedException | ExecutionException exception) {
            resultFuture.complete(MessageSendingResult.failedResult(exception));
        }
    }

    @Override
    public void stop() {
        this.clientsPool.release(this.resolvedTarget);
    }
}

