/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.pubsub.v1.TopicName;
import java.util.Objects;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.CompressionCodec;

class GooglePubSubSenderTarget {
    private final TopicName topicName;
    private final String pubSubEndpoint;
    private final CompressionCodec compressionCodec;

    private GooglePubSubSenderTarget(TopicName topicName, String pubSubEndpoint, CompressionCodec compressionCodec) {
        this.topicName = topicName;
        this.pubSubEndpoint = pubSubEndpoint;
        this.compressionCodec = compressionCodec;
    }

    TopicName getTopicName() {
        return this.topicName;
    }

    String getPubSubEndpoint() {
        return this.pubSubEndpoint;
    }

    CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    boolean isCompressionRequested() {
        return this.compressionCodec != CompressionCodec.EMPTY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.skipCompressionCodecEquals((GooglePubSubSenderTarget)o);
    }

    public int hashCode() {
        return this.skipCompressionCodecHashCode();
    }

    private boolean skipCompressionCodecEquals(GooglePubSubSenderTarget that) {
        return Objects.equals(this.topicName, that.topicName) && Objects.equals(this.pubSubEndpoint, that.pubSubEndpoint);
    }

    private int skipCompressionCodecHashCode() {
        return Objects.hash(this.topicName, this.pubSubEndpoint);
    }

    static PubSubTargetBuilder builder() {
        return new PubSubTargetBuilder();
    }

    static final class PubSubTargetBuilder {
        private TopicName topicName;
        private String pubSubEndpoint;
        private CompressionCodec compressionCodec;

        private PubSubTargetBuilder() {
        }

        PubSubTargetBuilder withTopicName(TopicName topicName) {
            this.topicName = topicName;
            return this;
        }

        PubSubTargetBuilder withPubSubEndpoint(String pubSubEndpoint) {
            this.pubSubEndpoint = pubSubEndpoint;
            return this;
        }

        PubSubTargetBuilder withCompressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        GooglePubSubSenderTarget build() {
            return new GooglePubSubSenderTarget(this.topicName, this.pubSubEndpoint, this.compressionCodec);
        }
    }
}

