/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.codahale.metrics.Gauge;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.consumers.consumer.SubscriptionMetrics;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerInstance;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRate;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.RateHistory;

public class NegotiatedMaxRateProvider
implements MaxRateProvider {
    private static final Logger logger = LoggerFactory.getLogger(NegotiatedMaxRateProvider.class);
    private final ConsumerInstance consumer;
    private final MaxRateRegistry registry;
    private final MaxRateSupervisor maxRateSupervisor;
    private final SendCounters sendCounters;
    private final SubscriptionMetrics metrics;
    private final double minSignificantChange;
    private final int historyLimit;
    private volatile double maxRate;
    private volatile double previousRecordedRate = -1.0;

    NegotiatedMaxRateProvider(String consumerId, MaxRateRegistry registry, MaxRateSupervisor maxRateSupervisor, Subscription subscription, SendCounters sendCounters, SubscriptionMetrics metrics, double initialMaxRate, double minSignificantChange, int historyLimit) {
        this.consumer = new ConsumerInstance(consumerId, subscription.getQualifiedName());
        this.registry = registry;
        this.maxRateSupervisor = maxRateSupervisor;
        this.sendCounters = sendCounters;
        this.metrics = metrics;
        this.minSignificantChange = minSignificantChange;
        this.historyLimit = historyLimit;
        this.maxRate = initialMaxRate;
    }

    @Override
    public double get() {
        return this.maxRate;
    }

    void tickForHistory() {
        this.recordCurrentRate(this.sendCounters.getRate());
        this.fetchCurrentMaxRate().ifPresent(currentMaxRate -> {
            this.maxRate = currentMaxRate.getMaxRate();
        });
    }

    private void recordCurrentRate(double actualRate) {
        double usedRate = Math.min(actualRate / Math.max(this.maxRate, 1.0), 1.0);
        if (this.shouldRecordHistory(usedRate)) {
            try {
                RateHistory rateHistory = this.registry.getRateHistory(this.consumer);
                RateHistory updatedHistory = RateHistory.updatedRates(rateHistory, usedRate, this.historyLimit);
                this.registry.writeRateHistory(this.consumer, updatedHistory);
                this.previousRecordedRate = usedRate;
            }
            catch (Exception e) {
                logger.warn("Encountered problem updating max rate for {}", (Object)this.consumer, (Object)e);
                this.metrics.rateHistoryFailuresCounter().inc();
            }
        }
    }

    private boolean shouldRecordHistory(double usedRate) {
        return this.previousRecordedRate < 0.0 || Math.abs(this.previousRecordedRate - usedRate) > this.minSignificantChange;
    }

    private Optional<MaxRate> fetchCurrentMaxRate() {
        try {
            return this.registry.getMaxRate(this.consumer);
        }
        catch (Exception e) {
            logger.warn("Encountered problem fetching max rate for {}", (Object)this.consumer);
            this.metrics.maxRateFetchFailuresCounter().inc();
            return Optional.empty();
        }
    }

    @Override
    public void start() {
        this.maxRateSupervisor.register(this);
        this.metrics.registerMaxRateGauge((Gauge<Double>)((Gauge)this::get));
        this.metrics.registerRateGauge((Gauge<Double>)((Gauge)this.sendCounters::getRate));
    }

    @Override
    public void shutdown() {
        this.maxRateSupervisor.unregister(this);
    }
}

