/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import pl.allegro.tech.hermes.common.metric.HermesMetrics;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientHolder;

public class HttpClientsWorkloadReporter {
    private final HermesMetrics metrics;
    private final HttpClient http1SerialClient;
    private final HttpClient http1BatchClient;
    private final Http2ClientHolder http2ClientHolder;
    private final boolean isRequestQueueMonitoringEnabled;
    private final boolean isConnectionPoolMonitoringEnabled;
    private final Function<HttpClient, Integer> getQueueSize = httpClient -> httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getHttpExchanges).map(Collection::size).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp1ActiveConnectionsCount = httpClient -> this.getHttp1ConnectionPool((HttpClient)httpClient).map(DuplexConnectionPool::getActiveConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp1IdleConnectionsCount = httpClient -> this.getHttp1ConnectionPool((HttpClient)httpClient).map(DuplexConnectionPool::getIdleConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp2ConnectionsCount = http2Client -> this.getHttp2ConnectionPool((HttpClient)http2Client).map(AbstractConnectionPool::getConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp2PendingConnectionsCount = http2Client -> this.getHttp2ConnectionPool((HttpClient)http2Client).map(AbstractConnectionPool::getPendingCount).mapToInt(i -> i).sum();

    public HttpClientsWorkloadReporter(HermesMetrics metrics, HttpClient http1SerialClient, HttpClient http1BatchClient, Http2ClientHolder http2ClientHolder, boolean isRequestQueueMonitoringEnabled, boolean isConnectionPoolMonitoringEnabled) {
        this.metrics = metrics;
        this.http1SerialClient = http1SerialClient;
        this.http1BatchClient = http1BatchClient;
        this.http2ClientHolder = http2ClientHolder;
        this.isRequestQueueMonitoringEnabled = isRequestQueueMonitoringEnabled;
        this.isConnectionPoolMonitoringEnabled = isConnectionPoolMonitoringEnabled;
    }

    public void start() {
        if (this.isRequestQueueMonitoringEnabled) {
            this.registerRequestQueueSizeGauges();
        }
        if (this.isConnectionPoolMonitoringEnabled) {
            this.registerConnectionGauges();
        }
    }

    private void registerRequestQueueSizeGauges() {
        this.metrics.registerConsumerSenderRequestQueueSize(this::getQueuesSize);
        this.metrics.registerConsumerSenderHttp1SerialClientRequestQueueSize(this::getHttp1SerialClientQueueSize);
        this.metrics.registerConsumerSenderHttp1BatchClientRequestQueueSize(this::getHttp1BatchClientQueueSize);
        this.metrics.registerConsumerSenderHttp2RequestQueueSize(this::getHttp2SerialClientQueueSize);
    }

    private void registerConnectionGauges() {
        this.metrics.registerGauge("http-clients.serial.http1.active-connections", () -> this.getHttp1ActiveConnectionsCount.apply(this.http1SerialClient));
        this.metrics.registerGauge("http-clients.serial.http1.idle-connections", () -> this.getHttp1IdleConnectionsCount.apply(this.http1SerialClient));
        this.metrics.registerGauge("http-clients.batch.http1.active-connections", () -> this.getHttp1ActiveConnectionsCount.apply(this.http1BatchClient));
        this.metrics.registerGauge("http-clients.batch.http1.idle-connections", () -> this.getHttp1IdleConnectionsCount.apply(this.http1BatchClient));
        this.metrics.registerGauge("http-clients.serial.http2.connections", () -> this.http2ClientHolder.getHttp2Client().map(this.getHttp2ConnectionsCount).orElse(0));
        this.metrics.registerGauge("http-clients.serial.http2.pending-connections", () -> this.http2ClientHolder.getHttp2Client().map(this.getHttp2PendingConnectionsCount).orElse(0));
    }

    int getQueuesSize() {
        return this.getHttp1SerialClientQueueSize() + this.getHttp1BatchClientQueueSize() + this.getHttp2SerialClientQueueSize();
    }

    int getHttp1SerialClientQueueSize() {
        return this.getQueueSize.apply(this.http1SerialClient);
    }

    int getHttp1BatchClientQueueSize() {
        return this.getQueueSize.apply(this.http1BatchClient);
    }

    int getHttp2SerialClientQueueSize() {
        return this.http2ClientHolder.getHttp2Client().map(this.getQueueSize).orElse(0);
    }

    private Stream<ConnectionPool> getConnectionPool(HttpClient httpClient) {
        return httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getConnectionPool);
    }

    private Stream<DuplexConnectionPool> getHttp1ConnectionPool(HttpClient httpClient) {
        return this.getConnectionPool(httpClient).map(DuplexConnectionPool.class::cast);
    }

    private Stream<MultiplexConnectionPool> getHttp2ConnectionPool(HttpClient http2Client) {
        return this.getConnectionPool(http2Client).map(MultiplexConnectionPool.class::cast);
    }
}

