/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs;

import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs.MetaAttribute;

public class ConsumerLoadDecoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConsumerLoadDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final SubscriptionsDecoder subscriptions = new SubscriptionsDecoder(this);

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 2;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ConsumerLoadDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int cpuUtilizationId() {
        return 1;
    }

    public static int cpuUtilizationSinceVersion() {
        return 0;
    }

    public static int cpuUtilizationEncodingOffset() {
        return 0;
    }

    public static int cpuUtilizationEncodingLength() {
        return 8;
    }

    public static String cpuUtilizationMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static double cpuUtilizationNullValue() {
        return Double.NaN;
    }

    public static double cpuUtilizationMinValue() {
        return Double.MIN_VALUE;
    }

    public static double cpuUtilizationMaxValue() {
        return Double.MAX_VALUE;
    }

    public double cpuUtilization() {
        return this.buffer.getDouble(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static long subscriptionsDecoderId() {
        return 2L;
    }

    public static int subscriptionsDecoderSinceVersion() {
        return 0;
    }

    public SubscriptionsDecoder subscriptions() {
        this.subscriptions.wrap(this.buffer);
        return this.subscriptions;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[ConsumerLoad](sbeTemplateId=");
        builder.append(2);
        builder.append("|sbeSchemaId=");
        builder.append(2);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 8) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(8);
        builder.append("):");
        builder.append("cpuUtilization=");
        builder.append(this.cpuUtilization());
        builder.append('|');
        builder.append("subscriptions=[");
        SubscriptionsDecoder subscriptions = this.subscriptions();
        if (subscriptions.count() > 0) {
            while (subscriptions.hasNext()) {
                subscriptions.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        this.limit(originalLimit);
        return builder;
    }

    public static class SubscriptionsDecoder
    implements Iterable<SubscriptionsDecoder>,
    Iterator<SubscriptionsDecoder> {
        public static final int HEADER_SIZE = 4;
        private final ConsumerLoadDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SubscriptionsDecoder(ConsumerLoadDecoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(DirectBuffer buffer) {
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = -1;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            this.blockLength = buffer.getShort(limit + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
            this.count = buffer.getShort(limit + 2, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 16;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<SubscriptionsDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public SubscriptionsDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int idId() {
            return 3;
        }

        public static int idSinceVersion() {
            return 0;
        }

        public static int idEncodingOffset() {
            return 0;
        }

        public static int idEncodingLength() {
            return 8;
        }

        public static String idMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static long idNullValue() {
            return Long.MIN_VALUE;
        }

        public static long idMinValue() {
            return -9223372036854775807L;
        }

        public static long idMaxValue() {
            return Long.MAX_VALUE;
        }

        public long id() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int operationsPerSecondId() {
            return 4;
        }

        public static int operationsPerSecondSinceVersion() {
            return 0;
        }

        public static int operationsPerSecondEncodingOffset() {
            return 8;
        }

        public static int operationsPerSecondEncodingLength() {
            return 8;
        }

        public static String operationsPerSecondMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "";
                }
                case TIME_UNIT: {
                    return "";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
                case PRESENCE: {
                    return "required";
                }
            }
            return "";
        }

        public static double operationsPerSecondNullValue() {
            return Double.NaN;
        }

        public static double operationsPerSecondMinValue() {
            return Double.MIN_VALUE;
        }

        public static double operationsPerSecondMaxValue() {
            return Double.MAX_VALUE;
        }

        public double operationsPerSecond() {
            return this.buffer.getDouble(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("id=");
            builder.append(this.id());
            builder.append('|');
            builder.append("operationsPerSecond=");
            builder.append(this.operationsPerSecond());
            builder.append(')');
            return builder;
        }
    }
}

