/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerRateHistory;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.RateHistory;
import pl.allegro.tech.hermes.consumers.consumer.rate.sbe.stubs.MessageHeaderDecoder;
import pl.allegro.tech.hermes.consumers.consumer.rate.sbe.stubs.RateHistoryDecoder;
import pl.allegro.tech.hermes.consumers.subscription.id.SubscriptionIds;

class ConsumerRateHistoriesDecoder {
    private final SubscriptionIds subscriptionIds;

    ConsumerRateHistoriesDecoder(SubscriptionIds subscriptionIds) {
        this.subscriptionIds = subscriptionIds;
    }

    ConsumerRateHistory decode(byte[] data) {
        MessageHeaderDecoder header = new MessageHeaderDecoder();
        RateHistoryDecoder body = new RateHistoryDecoder();
        UnsafeBuffer buffer = new UnsafeBuffer(data);
        header.wrap((DirectBuffer)buffer, 0);
        if (header.templateId() != 2) {
            throw new IllegalStateException(String.format("RateHistoryDecoder TEMPLATE_ID=%d does not match encoded TEMPLATE_ID=%d", 2, header.templateId()));
        }
        body.wrap((DirectBuffer)buffer, header.encodedLength(), header.blockLength(), header.version());
        ConsumerRateHistory result = new ConsumerRateHistory();
        for (RateHistoryDecoder.SubscriptionsDecoder subscriptionDecoder : body.subscriptions()) {
            long id = subscriptionDecoder.id();
            List rates = StreamSupport.stream(subscriptionDecoder.rates().spliterator(), false).map(RateHistoryDecoder.SubscriptionsDecoder.RatesDecoder::rate).collect(Collectors.toList());
            this.subscriptionIds.getSubscriptionId(id).ifPresent(subscriptionId -> result.setRateHistory(subscriptionId.getSubscriptionName(), new RateHistory(rates)));
        }
        return result;
    }
}

