/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.pubsub.v1.PubsubMessage;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageSentCallback;

class GooglePubSubClient {
    private static final Logger logger = LoggerFactory.getLogger(GooglePubSubClient.class);
    private final Publisher publisher;

    GooglePubSubClient(Publisher publisher) {
        this.publisher = publisher;
    }

    void publish(PubsubMessage pubsubMessage, CompletableFuture<MessageSendingResult> resultFuture) throws IOException, ExecutionException, InterruptedException {
        ApiFuture future = this.publisher.publish(pubsubMessage);
        ApiFutures.addCallback((ApiFuture)future, (ApiFutureCallback)new GooglePubSubMessageSentCallback(resultFuture), (Executor)MoreExecutors.directExecutor());
    }

    void shutdown() {
        this.publisher.shutdown();
        try {
            this.publisher.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted termination of the PubSub publisher.");
        }
    }
}

