/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import java.time.Clock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.SentMessageTrace;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.message.undelivered.UndeliveredMessageLog;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetQueue;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.result.ErrorHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.metrics.HermesCounter;
import pl.allegro.tech.hermes.metrics.HermesHistogram;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultErrorHandler.class);
    private final OffsetQueue offsetQueue;
    private final MetricsFacade metrics;
    private final UndeliveredMessageLog undeliveredMessageLog;
    private final Clock clock;
    private final Trackers trackers;
    private final String cluster;
    private final SubscriptionName subscriptionName;
    private final HermesCounter failures;
    private final HermesCounter timeouts;
    private final HermesCounter otherErrors;
    private final HermesCounter discarded;
    private final HermesHistogram inflightTime;
    private final HermesCounter throughputInBytes;
    private final Map<Integer, HermesCounter> httpStatusCodes = new ConcurrentHashMap<Integer, HermesCounter>();

    public DefaultErrorHandler(OffsetQueue offsetQueue, MetricsFacade metrics, UndeliveredMessageLog undeliveredMessageLog, Clock clock, Trackers trackers, String cluster, SubscriptionName subscriptionName) {
        this.offsetQueue = offsetQueue;
        this.metrics = metrics;
        this.undeliveredMessageLog = undeliveredMessageLog;
        this.clock = clock;
        this.trackers = trackers;
        this.cluster = cluster;
        this.subscriptionName = subscriptionName;
        this.failures = metrics.subscriptions().failuresCounter(subscriptionName);
        this.timeouts = metrics.subscriptions().timeoutsCounter(subscriptionName);
        this.otherErrors = metrics.subscriptions().otherErrorsCounter(subscriptionName);
        this.discarded = metrics.subscriptions().discarded(subscriptionName);
        this.inflightTime = metrics.subscriptions().inflightTimeInMillisHistogram(subscriptionName);
        this.throughputInBytes = metrics.subscriptions().throughputInBytes(subscriptionName);
    }

    @Override
    public void handleDiscarded(Message message, Subscription subscription, MessageSendingResult result) {
        this.logResult(message, subscription, result);
        this.offsetQueue.offerCommittedOffset(SubscriptionPartitionOffset.subscriptionPartitionOffset(subscription.getQualifiedName(), message.getPartitionOffset(), message.getPartitionAssignmentTerm()));
        this.discarded.increment();
        this.inflightTime.record(System.currentTimeMillis() - message.getReadingTimestamp());
        this.addToMessageLog(message, subscription, result);
        this.trackers.get(subscription).logDiscarded(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause());
    }

    private void addToMessageLog(Message message, Subscription subscription, MessageSendingResult result) {
        result.getLogInfo().forEach(logInfo -> this.undeliveredMessageLog.add(SentMessageTrace.Builder.undeliveredMessage().withSubscription(subscription.getName()).withTopicName(subscription.getQualifiedTopicName()).withMessage(new String(message.getData())).withReason(logInfo.getFailure().getMessage()).withTimestamp(this.clock.millis()).withPartition(Integer.valueOf(message.getPartition())).withOffset(Long.valueOf(message.getOffset())).withCluster(this.cluster).build()));
    }

    private void logResult(Message message, Subscription subscription, MessageSendingResult result) {
        if (result.isLoggable()) {
            result.getLogInfo().forEach(logInfo -> logger.warn("Abnormal delivery failure: subscription: {}; cause: {}; endpoint: {}; messageId: {}; partition: {}; offset: {}", new Object[]{subscription.getQualifiedName(), logInfo.getRootCause(), logInfo.getUrlString(), message.getId(), message.getPartition(), message.getOffset(), logInfo.getFailure()}));
        }
    }

    @Override
    public void handleFailed(Message message, Subscription subscription, MessageSendingResult result) {
        this.failures.increment();
        if (result.hasHttpAnswer()) {
            this.markHttpStatusCode(result.getStatusCode());
        } else if (result.isTimeout()) {
            this.timeouts.increment();
        } else {
            this.otherErrors.increment();
        }
        this.throughputInBytes.increment(message.getSize());
        this.trackers.get(subscription).logFailed(MessageConverter.toMessageMetadata(message, subscription), result.getRootCause(), result.getHostname());
    }

    private void markHttpStatusCode(int statusCode) {
        this.httpStatusCodes.computeIfAbsent(statusCode, integer -> this.metrics.subscriptions().httpAnswerCounter(this.subscriptionName, statusCode)).increment();
    }
}

