/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.result;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.message.MessageConverter;
import pl.allegro.tech.hermes.consumers.consumer.offset.OffsetQueue;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.consumer.result.SuccessHandler;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.metrics.HermesCounter;
import pl.allegro.tech.hermes.metrics.HermesHistogram;
import pl.allegro.tech.hermes.tracker.consumers.Trackers;

public class DefaultSuccessHandler
implements SuccessHandler {
    private final Trackers trackers;
    private final SubscriptionName subscriptionName;
    private final OffsetQueue offsetQueue;
    private final MetricsFacade metrics;
    private final Map<Integer, HermesCounter> httpStatusCodes = new ConcurrentHashMap<Integer, HermesCounter>();
    private final HermesCounter throughputInBytes;
    private final HermesCounter successes;
    private final HermesHistogram inflightTime;

    public DefaultSuccessHandler(OffsetQueue offsetQueue, MetricsFacade metrics, Trackers trackers, SubscriptionName subscriptionName) {
        this.offsetQueue = offsetQueue;
        this.metrics = metrics;
        this.trackers = trackers;
        this.subscriptionName = subscriptionName;
        this.throughputInBytes = metrics.subscriptions().throughputInBytes(subscriptionName);
        this.successes = metrics.subscriptions().successes(subscriptionName);
        this.inflightTime = metrics.subscriptions().inflightTimeInMillisHistogram(subscriptionName);
    }

    @Override
    public void handleSuccess(Message message, Subscription subscription, MessageSendingResult result) {
        this.offsetQueue.offerCommittedOffset(SubscriptionPartitionOffset.subscriptionPartitionOffset(subscription.getQualifiedName(), message.getPartitionOffset(), message.getPartitionAssignmentTerm()));
        this.markSuccess(message, result);
        this.trackers.get(subscription).logSent(MessageConverter.toMessageMetadata(message, subscription), result.getHostname());
    }

    private void markSuccess(Message message, MessageSendingResult result) {
        this.successes.increment();
        this.throughputInBytes.increment(message.getSize());
        this.markHttpStatusCode(result.getStatusCode());
        this.inflightTime.record(System.currentTimeMillis() - message.getReadingTimestamp());
    }

    private void markHttpStatusCode(int statusCode) {
        this.httpStatusCodes.computeIfAbsent(statusCode, integer -> this.metrics.subscriptions().httpAnswerCounter(this.subscriptionName, statusCode)).increment();
    }
}

