/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.CookieStore;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.HttpCookieStore;
import pl.allegro.tech.hermes.common.metric.executor.InstrumentedExecutorServiceFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http1ClientParameters;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientParameters;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SslContextFactoryProvider;

public class HttpClientsFactory {
    private final InstrumentedExecutorServiceFactory executorFactory;
    private final SslContextFactoryProvider sslContextFactoryProvider;

    public HttpClientsFactory(InstrumentedExecutorServiceFactory executorFactory, SslContextFactoryProvider sslContextFactoryProvider) {
        this.executorFactory = executorFactory;
        this.sslContextFactoryProvider = sslContextFactoryProvider;
    }

    public HttpClient createClientForHttp1(String name, Http1ClientParameters http1ClientParameters) {
        ClientConnector clientConnector = new ClientConnector();
        this.sslContextFactoryProvider.provideSslContextFactory().ifPresent(arg_0 -> ((ClientConnector)clientConnector).setSslContextFactory(arg_0));
        HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP(clientConnector);
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        ExecutorService executor = this.executorFactory.getExecutorService(name, http1ClientParameters.getThreadPoolSize(), http1ClientParameters.isThreadPoolMonitoringEnabled());
        client.setExecutor((Executor)executor);
        client.setMaxConnectionsPerDestination(http1ClientParameters.getMaxConnectionsPerDestination());
        client.setMaxRequestsQueuedPerDestination(http1ClientParameters.getMaxRequestsQueuedPerDestination());
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setIdleTimeout(http1ClientParameters.getIdleTimeout().toMillis());
        client.setFollowRedirects(http1ClientParameters.isFollowRedirectsEnabled());
        client.setConnectTimeout(http1ClientParameters.getConnectionTimeout().toMillis());
        return client;
    }

    public HttpClient createClientForHttp2(String name, Http2ClientParameters http2ClientParameters) {
        ClientConnector clientConnector = new ClientConnector();
        this.sslContextFactoryProvider.provideSslContextFactory().ifPresentOrElse(arg_0 -> ((ClientConnector)clientConnector).setSslContextFactory(arg_0), () -> {
            throw new IllegalStateException("Cannot create http/2 client due to lack of ssl context factory");
        });
        HTTP2Client http2Client = new HTTP2Client(clientConnector);
        ExecutorService executor = this.executorFactory.getExecutorService(name, http2ClientParameters.getThreadPoolSize(), http2ClientParameters.isThreadPoolMonitoringEnabled());
        http2Client.setExecutor((Executor)executor);
        HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(http2Client);
        HttpClient client = new HttpClient((HttpClientTransport)transport);
        client.setMaxRequestsQueuedPerDestination(http2ClientParameters.getMaxRequestsQueuedPerDestination());
        client.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        client.setIdleTimeout(http2ClientParameters.getIdleTimeout().toMillis());
        client.setFollowRedirects(http2ClientParameters.isFollowRedirectsEnabled());
        client.setConnectTimeout(http2ClientParameters.getConnectionTimeout().toMillis());
        return client;
    }
}

