/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.Http2ClientHolder;

public class HttpClientsWorkloadReporter {
    private final MetricsFacade metrics;
    private final HttpClient http1SerialClient;
    private final HttpClient http1BatchClient;
    private final Http2ClientHolder http2ClientHolder;
    private final boolean isRequestQueueMonitoringEnabled;
    private final boolean isConnectionPoolMonitoringEnabled;
    private final Function<HttpClient, Integer> getQueueSize = httpClient -> httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getHttpExchanges).map(Collection::size).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp1ActiveConnectionsCount = httpClient -> this.getHttp1ConnectionPool((HttpClient)httpClient).map(AbstractConnectionPool::getActiveConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp1IdleConnectionsCount = httpClient -> this.getHttp1ConnectionPool((HttpClient)httpClient).map(AbstractConnectionPool::getIdleConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp2ConnectionsCount = http2Client -> this.getHttp2ConnectionPool((HttpClient)http2Client).map(AbstractConnectionPool::getConnectionCount).mapToInt(i -> i).sum();
    private final Function<HttpClient, Integer> getHttp2PendingConnectionsCount = http2Client -> this.getHttp2ConnectionPool((HttpClient)http2Client).map(AbstractConnectionPool::getPendingConnectionCount).mapToInt(i -> i).sum();

    public HttpClientsWorkloadReporter(MetricsFacade metrics, HttpClient http1SerialClient, HttpClient http1BatchClient, Http2ClientHolder http2ClientHolder, boolean isRequestQueueMonitoringEnabled, boolean isConnectionPoolMonitoringEnabled) {
        this.metrics = metrics;
        this.http1SerialClient = http1SerialClient;
        this.http1BatchClient = http1BatchClient;
        this.http2ClientHolder = http2ClientHolder;
        this.isRequestQueueMonitoringEnabled = isRequestQueueMonitoringEnabled;
        this.isConnectionPoolMonitoringEnabled = isConnectionPoolMonitoringEnabled;
    }

    public void start() {
        if (this.isRequestQueueMonitoringEnabled) {
            this.registerRequestQueueSizeGauges();
        }
        if (this.isConnectionPoolMonitoringEnabled) {
            this.registerConnectionGauges();
        }
    }

    private void registerRequestQueueSizeGauges() {
        this.metrics.consumerSender().registerRequestQueueSizeGauge((Object)this, HttpClientsWorkloadReporter::getQueuesSize);
        this.metrics.consumerSender().registerHttp1SerialClientRequestQueueSizeGauge((Object)this, HttpClientsWorkloadReporter::getHttp1SerialQueueSize);
        this.metrics.consumerSender().registerHttp1BatchClientRequestQueueSizeGauge((Object)this, HttpClientsWorkloadReporter::getHttp1BatchQueueSize);
        this.metrics.consumerSender().registerHttp2RequestQueueSizeGauge((Object)this, HttpClientsWorkloadReporter::getHttp2SerialQueueSize);
    }

    private void registerConnectionGauges() {
        this.metrics.consumerSender().registerHttp1SerialClientActiveConnectionsGauge((Object)this, HttpClientsWorkloadReporter::getHttp1SerialActiveConnections);
        this.metrics.consumerSender().registerHttp1SerialClientIdleConnectionsGauge((Object)this, HttpClientsWorkloadReporter::getHttp1SerialIdleConnections);
        this.metrics.consumerSender().registerHttp1BatchClientActiveConnectionsGauge((Object)this, HttpClientsWorkloadReporter::getHttp1BatchActiveConnections);
        this.metrics.consumerSender().registerHttp1BatchClientIdleConnectionsGauge((Object)this, HttpClientsWorkloadReporter::getHttp1BatchIdleConnections);
        this.metrics.consumerSender().registerHttp2SerialClientConnectionsGauge((Object)this, HttpClientsWorkloadReporter::getHttp2SerialConnections);
        this.metrics.consumerSender().registerHttp2SerialClientPendingConnectionsGauge((Object)this, HttpClientsWorkloadReporter::getHttp2SerialPendingConnections);
    }

    int getQueuesSize() {
        return this.getHttp1SerialQueueSize() + this.getHttp1BatchQueueSize() + this.getHttp2SerialQueueSize();
    }

    int getHttp1SerialQueueSize() {
        return this.getQueueSize.apply(this.http1SerialClient);
    }

    int getHttp1BatchQueueSize() {
        return this.getQueueSize.apply(this.http1BatchClient);
    }

    int getHttp2SerialQueueSize() {
        return this.http2ClientHolder.getHttp2Client().map(this.getQueueSize).orElse(0);
    }

    private int getHttp1SerialActiveConnections() {
        return this.getHttp1ActiveConnectionsCount.apply(this.http1SerialClient);
    }

    private int getHttp1SerialIdleConnections() {
        return this.getHttp1IdleConnectionsCount.apply(this.http1SerialClient);
    }

    private int getHttp1BatchActiveConnections() {
        return this.getHttp1ActiveConnectionsCount.apply(this.http1BatchClient);
    }

    private int getHttp1BatchIdleConnections() {
        return this.getHttp1IdleConnectionsCount.apply(this.http1BatchClient);
    }

    private int getHttp2SerialConnections() {
        return this.http2ClientHolder.getHttp2Client().map(this.getHttp2ConnectionsCount).orElse(0);
    }

    private int getHttp2SerialPendingConnections() {
        return this.http2ClientHolder.getHttp2Client().map(this.getHttp2PendingConnectionsCount).orElse(0);
    }

    private Stream<ConnectionPool> getConnectionPool(HttpClient httpClient) {
        return httpClient.getDestinations().stream().map(HttpDestination.class::cast).map(HttpDestination::getConnectionPool);
    }

    private Stream<DuplexConnectionPool> getHttp1ConnectionPool(HttpClient httpClient) {
        return this.getConnectionPool(httpClient).map(DuplexConnectionPool.class::cast);
    }

    private Stream<MultiplexConnectionPool> getHttp2ConnectionPool(HttpClient http2Client) {
        return this.getConnectionPool(http2Client).map(MultiplexConnectionPool.class::cast);
    }
}

