/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.oauth.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.entity.ContentType;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.consumers.consumer.oauth.OAuthAccessToken;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthClient;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenRequest;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenRequestException;
import pl.allegro.tech.hermes.consumers.consumer.oauth.client.OAuthTokenResponse;

public class OAuthHttpClient
implements OAuthClient {
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public OAuthHttpClient(HttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public OAuthAccessToken getToken(OAuthTokenRequest request) {
        ContentResponse response = this.performHttpRequest(request);
        this.validateHttpResponse(response);
        OAuthTokenResponse accessTokenResponse = this.httpResponseToOAuthAccessTokenResponse(response);
        return accessTokenResponse.toAccessToken();
    }

    private Request createHttpRequest(OAuthTokenRequest request) {
        Request httpRequest = this.httpClient.newRequest(request.getUrl()).timeout((long)request.getRequestTimeout().intValue(), TimeUnit.MILLISECONDS).idleTimeout((long)request.getSocketTimeout().intValue(), TimeUnit.MILLISECONDS).method(HttpMethod.POST).headers(headers -> {
            headers.add(HttpHeader.KEEP_ALIVE, "true");
            headers.add(HttpHeader.CONTENT_TYPE, ContentType.APPLICATION_FORM_URLENCODED.toString());
        });
        this.addParamIfNotNull(httpRequest, "grant_type", request.getGrantType());
        this.addParamIfNotNull(httpRequest, "scope", request.getScope());
        this.addParamIfNotNull(httpRequest, "client_id", request.getClientId());
        this.addParamIfNotNull(httpRequest, "client_secret", request.getClientSecret());
        if ("password".equals(request.getGrantType())) {
            this.addParamIfNotNull(httpRequest, "username", request.getUsername());
            this.addParamIfNotNull(httpRequest, "password", request.getPassword());
        }
        return httpRequest;
    }

    private void addParamIfNotNull(Request request, String name, String value) {
        if (value != null) {
            request.param(name, value);
        }
    }

    private ContentResponse performHttpRequest(OAuthTokenRequest request) {
        try {
            return this.createHttpRequest(request).send();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new OAuthTokenRequestException("An exception occurred while performing token request", e);
        }
    }

    private void validateHttpResponse(ContentResponse response) {
        if (response.getStatus() != 200) {
            throw new OAuthTokenRequestException(String.format("%d %s response when performing token request", response.getStatus(), response.getContentAsString()));
        }
    }

    private OAuthTokenResponse httpResponseToOAuthAccessTokenResponse(ContentResponse response) {
        try {
            return (OAuthTokenResponse)this.objectMapper.readValue(response.getContentAsString(), OAuthTokenResponse.class);
        }
        catch (IOException e) {
            throw new OAuthTokenRequestException("An exception occurred while reading token response", e);
        }
    }

    @Override
    public void start() {
        try {
            this.httpClient.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void stop() {
        try {
            this.httpClient.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

