/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class AdjustableSemaphore {
    private final ResizeableSemaphore semaphore;
    private int maxPermits = 0;

    public AdjustableSemaphore(int maxPermits) {
        this.maxPermits = maxPermits;
        this.semaphore = new ResizeableSemaphore(maxPermits);
    }

    public synchronized void setMaxPermits(int newMax) {
        if (newMax < 1) {
            throw new IllegalArgumentException("Semaphore size must be at least 1, was " + newMax);
        }
        int delta = newMax - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.semaphore.release(delta);
        } else {
            this.semaphore.reducePermits(delta *= -1);
        }
        this.maxPermits = newMax;
    }

    public void release() {
        this.semaphore.release();
    }

    public void acquire() throws InterruptedException {
        this.semaphore.acquire();
    }

    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.semaphore.tryAcquire(timeout, unit);
    }

    public int availablePermits() {
        return this.semaphore.availablePermits();
    }

    private static final class ResizeableSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1L;

        ResizeableSemaphore(int maxPermits) {
            super(maxPermits);
        }

        @Override
        protected void reducePermits(int reduction) {
            super.reducePermits(reduction);
        }
    }
}

