/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.UNSAFE)
public class ByteBufferEntity
extends AbstractHttpEntity
implements Cloneable {
    private final ByteBuffer buffer;

    public ByteBufferEntity(ByteBuffer buffer, ContentType contentType) {
        Args.notNull((Object)buffer, (String)"Source byte buffer");
        this.buffer = buffer;
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
    }

    public ByteBufferEntity(ByteBuffer buffer) {
        this(buffer, null);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        return this.buffer.limit();
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return new ByteBufferInputStream();
    }

    public void writeTo(OutputStream outstream) throws IOException {
        Args.notNull((Object)outstream, (String)"Output stream");
        WritableByteChannel channel = Channels.newChannel(outstream);
        channel.write(this.buffer);
        outstream.flush();
    }

    public boolean isStreaming() {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private class ByteBufferInputStream
    extends InputStream {
        ByteBufferInputStream() {
            ByteBufferEntity.this.buffer.position(0);
        }

        @Override
        public int read() throws IOException {
            if (!ByteBufferEntity.this.buffer.hasRemaining()) {
                return -1;
            }
            return ByteBufferEntity.this.buffer.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!ByteBufferEntity.this.buffer.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, ByteBufferEntity.this.buffer.remaining());
            ByteBufferEntity.this.buffer.get(bytes, off, len);
            return len;
        }
    }
}

