/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.URI;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.http.entity.ContentType;
import org.eclipse.jetty.client.ContentResponse;
import org.eclipse.jetty.client.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.api.EndpointAddressResolverMetadata;
import pl.allegro.tech.hermes.common.http.MessageMetadataHeaders;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageBatchSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.BatchHttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpBatchSenderException;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.SendingResultHandlers;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.BatchHttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolutionException;
import pl.allegro.tech.hermes.consumers.consumer.sender.resolver.EndpointAddressResolver;

public class JettyMessageBatchSender
implements MessageBatchSender {
    private static final Logger logger = LoggerFactory.getLogger(JettyMessageBatchSender.class);
    private final BatchHttpRequestFactory requestFactory;
    private final EndpointAddressResolver resolver;
    private final SendingResultHandlers resultHandlers;
    private final BatchHttpHeadersProvider headersProvider;

    public JettyMessageBatchSender(BatchHttpRequestFactory requestFactory, EndpointAddressResolver resolver, SendingResultHandlers resultHandlers, BatchHttpHeadersProvider headersProvider) {
        this.requestFactory = requestFactory;
        this.resolver = resolver;
        this.resultHandlers = resultHandlers;
        this.headersProvider = headersProvider;
    }

    @Override
    public MessageSendingResult send(MessageBatch batch, EndpointAddress address, EndpointAddressResolverMetadata metadata, int requestTimeout) {
        try {
            HttpRequestHeaders headers = this.headersProvider.getHeaders(address);
            return this.send(batch, this.resolver.resolve(address, batch, metadata), requestTimeout, headers);
        }
        catch (EndpointAddressResolutionException e) {
            return MessageSendingResult.failedResult(e);
        }
    }

    private MessageSendingResult send(MessageBatch batch, URI address, int requestTimeout, HttpRequestHeaders baseHeaders) {
        HttpRequestHeaders headers = this.buildHeaders(batch, baseHeaders);
        Request request = this.requestFactory.buildRequest(batch, address, headers, requestTimeout);
        try {
            ContentResponse response = request.send();
            return this.resultHandlers.handleSendingResultForBatch(response);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                logger.info("Restoring interrupted status", (Throwable)e);
            }
            throw new HttpBatchSenderException("Failed to send message batch", e);
        }
    }

    private HttpRequestHeaders buildHeaders(MessageBatch batch, HttpRequestHeaders baseHeaders) {
        HashMap<String, String> headers = new HashMap<String, String>(baseHeaders.asMap());
        ContentType contentType = this.getMediaType(batch.getContentType());
        headers.put(MessageMetadataHeaders.BATCH_ID.getName(), batch.getId());
        headers.put("Content-Type", contentType.getMimeType());
        headers.put(MessageMetadataHeaders.RETRY_COUNT.getName(), Integer.toString(batch.getRetryCounter()));
        if (batch.hasSubscriptionIdentityHeaders()) {
            headers.put(MessageMetadataHeaders.TOPIC_NAME.getName(), batch.getTopic());
            headers.put(MessageMetadataHeaders.SUBSCRIPTION_NAME.getName(), batch.getSubscription().getName());
        }
        batch.getAdditionalHeaders().forEach(header -> headers.put(header.getName(), header.getValue()));
        return new HttpRequestHeaders(headers);
    }

    private ContentType getMediaType(pl.allegro.tech.hermes.api.ContentType contentType) {
        return pl.allegro.tech.hermes.api.ContentType.AVRO.equals((Object)contentType) ? ContentType.create((String)"avro/binary") : ContentType.APPLICATION_JSON;
    }
}

