/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.sbe.stubs;

import java.nio.ByteOrder;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import pl.allegro.tech.hermes.consumers.consumer.rate.sbe.stubs.MessageHeaderEncoder;
import pl.allegro.tech.hermes.consumers.consumer.rate.sbe.stubs.MetaAttribute;
import pl.allegro.tech.hermes.consumers.consumer.rate.sbe.stubs.RateHistoryDecoder;

public final class RateHistoryEncoder {
    public static final int BLOCK_LENGTH = 0;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final RateHistoryEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final SubscriptionsEncoder subscriptions = new SubscriptionsEncoder(this);

    public int sbeBlockLength() {
        return 0;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RateHistoryEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 0);
        return this;
    }

    public RateHistoryEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(0).templateId(2).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static long subscriptionsId() {
        return 1L;
    }

    public SubscriptionsEncoder subscriptionsCount(int count) {
        this.subscriptions.wrap(this.buffer, count);
        return this.subscriptions;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        RateHistoryDecoder decoder = new RateHistoryDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 0, 0);
        return decoder.appendTo(builder);
    }

    public static final class SubscriptionsEncoder {
        public static final int HEADER_SIZE = 4;
        private final RateHistoryEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;
        private final RatesEncoder rates;

        SubscriptionsEncoder(RateHistoryEncoder parentMessage) {
            this.parentMessage = parentMessage;
            this.rates = new RatesEncoder(parentMessage);
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)8, BYTE_ORDER);
            buffer.putShort(limit + 2, (short)count, BYTE_ORDER);
        }

        public SubscriptionsEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + SubscriptionsEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, BYTE_ORDER);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public static int idId() {
            return 2;
        }

        public static int idSinceVersion() {
            return 0;
        }

        public static int idEncodingOffset() {
            return 0;
        }

        public static int idEncodingLength() {
            return 8;
        }

        public static String idMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long idNullValue() {
            return Long.MIN_VALUE;
        }

        public static long idMinValue() {
            return -9223372036854775807L;
        }

        public static long idMaxValue() {
            return Long.MAX_VALUE;
        }

        public SubscriptionsEncoder id(long value) {
            this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
            return this;
        }

        public static long ratesId() {
            return 3L;
        }

        public RatesEncoder ratesCount(int count) {
            this.rates.wrap(this.buffer, count);
            return this.rates;
        }

        public static final class RatesEncoder {
            public static final int HEADER_SIZE = 4;
            private final RateHistoryEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int count;
            private int index;
            private int offset;
            private int initialLimit;

            RatesEncoder(RateHistoryEncoder parentMessage) {
                this.parentMessage = parentMessage;
            }

            public void wrap(MutableDirectBuffer buffer, int count) {
                int limit;
                if (count < 0 || count > 65534) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                if (buffer != this.buffer) {
                    this.buffer = buffer;
                }
                this.index = 0;
                this.count = count;
                this.initialLimit = limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 4);
                buffer.putShort(limit + 0, (short)8, BYTE_ORDER);
                buffer.putShort(limit + 2, (short)count, BYTE_ORDER);
            }

            public RatesEncoder next() {
                if (this.index >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + RatesEncoder.sbeBlockLength());
                ++this.index;
                return this;
            }

            public int resetCountToIndex() {
                this.count = this.index;
                this.buffer.putShort(this.initialLimit + 2, (short)this.count, BYTE_ORDER);
                return this.count;
            }

            public static int countMinValue() {
                return 0;
            }

            public static int countMaxValue() {
                return 65534;
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 8;
            }

            public static int rateId() {
                return 4;
            }

            public static int rateSinceVersion() {
                return 0;
            }

            public static int rateEncodingOffset() {
                return 0;
            }

            public static int rateEncodingLength() {
                return 8;
            }

            public static String rateMetaAttribute(MetaAttribute metaAttribute) {
                if (MetaAttribute.PRESENCE == metaAttribute) {
                    return "required";
                }
                return "";
            }

            public static double rateNullValue() {
                return Double.NaN;
            }

            public static double rateMinValue() {
                return Double.MIN_VALUE;
            }

            public static double rateMaxValue() {
                return Double.MAX_VALUE;
            }

            public RatesEncoder rate(double value) {
                this.buffer.putDouble(this.offset + 0, value, BYTE_ORDER);
                return this;
            }
        }
    }
}

