/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.offset;

import org.jctools.queues.MessagePassingQueue;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.offset.SubscriptionPartitionOffset;
import pl.allegro.tech.hermes.consumers.queue.FullDrainMpscQueue;
import pl.allegro.tech.hermes.consumers.queue.MonitoredMpscQueue;
import pl.allegro.tech.hermes.consumers.queue.MpscQueue;
import pl.allegro.tech.hermes.consumers.queue.WaitFreeDrainMpscQueue;

public class OffsetQueue {
    private final MpscQueue<SubscriptionPartitionOffset> inflightOffsetsQueue;
    private final MpscQueue<SubscriptionPartitionOffset> commitOffsetsQueue;

    public OffsetQueue(MetricsFacade metrics, int commitOffsetQueuesSize) {
        this.inflightOffsetsQueue = new MonitoredMpscQueue<SubscriptionPartitionOffset>(new FullDrainMpscQueue(commitOffsetQueuesSize), metrics, "inflightOffsets");
        this.commitOffsetsQueue = new MonitoredMpscQueue<SubscriptionPartitionOffset>(new WaitFreeDrainMpscQueue(commitOffsetQueuesSize), metrics, "committedOffsets");
    }

    public void offerInflightOffset(SubscriptionPartitionOffset offset) {
        this.inflightOffsetsQueue.offer(offset);
    }

    public void offerCommittedOffset(SubscriptionPartitionOffset offset) {
        this.commitOffsetsQueue.offer(offset);
    }

    public void drainInflightOffsets(MessagePassingQueue.Consumer<SubscriptionPartitionOffset> consumer) {
        this.inflightOffsetsQueue.drain(consumer);
    }

    public void drainCommittedOffsets(MessagePassingQueue.Consumer<SubscriptionPartitionOffset> consumer) {
        this.commitOffsetsQueue.drain(consumer);
    }
}

