/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.rate.SendCounters;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateParameters;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateProvider;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateSupervisor;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.NegotiatedMaxRateProvider;

public class MaxRateProviderFactory {
    private final Creator providerCreator;

    public MaxRateProviderFactory(MaxRateParameters maxRateParameters, String nodeId, MaxRateRegistry maxRateRegistry, MaxRateSupervisor maxRateSupervisor) {
        double minSignificantChange = maxRateParameters.getMinSignificantUpdatePercent() / 100.0;
        this.checkNegotiatedSettings(minSignificantChange, maxRateParameters.getBusyTolerance());
        this.providerCreator = (subscription, sendCounters, metrics) -> {
            int historyLimit = maxRateParameters.getHistorySize();
            double initialMaxRate = maxRateParameters.getMinMaxRate();
            return new NegotiatedMaxRateProvider(nodeId, maxRateRegistry, maxRateSupervisor, subscription, sendCounters, metrics, initialMaxRate, minSignificantChange, historyLimit);
        };
    }

    public MaxRateProvider create(Subscription subscription, SendCounters sendCounters, MetricsFacade metrics) {
        return this.providerCreator.create(subscription, sendCounters, metrics);
    }

    private void checkNegotiatedSettings(double minSignificantChange, double busyTolerance) {
        Preconditions.checkArgument((busyTolerance > minSignificantChange ? 1 : 0) != 0, (String)"Significant rate change (%s) can't be higher than busy tolerance (%s)", (Object)minSignificantChange, (Object)busyTolerance);
    }

    private static interface Creator {
        public MaxRateProvider create(Subscription var1, SendCounters var2, MetricsFacade var3);
    }
}

