/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.ResilientMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.CompletableFutureAwareMessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSender;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;

public class SingleRecipientMessageSenderAdapter
implements MessageSender {
    private final CompletableFutureAwareMessageSender adaptee;
    private final Function<Throwable, MessageSendingResult> exceptionMapper = MessageSendingResult::failedResult;
    private final ResilientMessageSender resilientMessageSender;

    public SingleRecipientMessageSenderAdapter(CompletableFutureAwareMessageSender adaptee, ResilientMessageSender resilientMessageSender) {
        this.resilientMessageSender = resilientMessageSender;
        this.adaptee = adaptee;
    }

    @Override
    public CompletableFuture<MessageSendingResult> send(Message message) {
        return this.resilientMessageSender.send(resultFuture -> this.adaptee.send(message, (CompletableFuture<MessageSendingResult>)resultFuture), this.exceptionMapper);
    }

    @Override
    public void stop() {
        this.adaptee.stop();
    }
}

