/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.batch;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import pl.allegro.tech.hermes.consumers.consumer.batch.DirectBufferUtils;

public final class DirectBufferPool {
    private final long totalMemory;
    private final int poolableSize;
    private final boolean blockOnExhaustion;
    private final ReentrantLock lock;
    private final Deque<ByteBuffer> free;
    private final Deque<Condition> waiters;
    private long availableMemory;

    public DirectBufferPool(long memory, int poolableSize, boolean blockOnExhaustion) {
        this.poolableSize = poolableSize;
        this.blockOnExhaustion = blockOnExhaustion;
        this.lock = new ReentrantLock();
        this.free = new ArrayDeque<ByteBuffer>();
        this.waiters = new ArrayDeque<Condition>();
        this.totalMemory = memory;
        this.availableMemory = memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer allocate(int size) throws InterruptedException {
        if ((long)size > this.totalMemory) {
            throw new IllegalArgumentException("Attempt to allocate " + size + " bytes, but there is a hard limit of " + this.totalMemory + " on memory allocations.");
        }
        this.lock.lock();
        try {
            if (size == this.poolableSize && !this.free.isEmpty()) {
                ByteBuffer byteBuffer = this.free.pollFirst();
                return byteBuffer;
            }
            int freeListSize = this.free.size() * this.poolableSize;
            if (this.availableMemory + (long)freeListSize >= (long)size) {
                this.freeUp(size);
                this.availableMemory -= (long)size;
                this.lock.unlock();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
                return byteBuffer;
            }
            if (!this.blockOnExhaustion) {
                throw new BufferOverflowException();
            }
            int accumulated = 0;
            ByteBuffer buffer = null;
            Condition moreMemory = this.lock.newCondition();
            this.waiters.addLast(moreMemory);
            while (accumulated < size) {
                moreMemory.await();
                if (accumulated == 0 && size == this.poolableSize && !this.free.isEmpty()) {
                    buffer = this.free.pollFirst();
                    accumulated = size;
                    continue;
                }
                this.freeUp(size - accumulated);
                int got = (int)Math.min((long)(size - accumulated), this.availableMemory);
                this.availableMemory -= (long)got;
                accumulated += got;
            }
            Condition removed = this.waiters.removeFirst();
            if (removed != moreMemory) {
                throw new IllegalStateException("Wrong condition: this shouldn't happen.");
            }
            if (!(this.availableMemory <= 0L && this.free.isEmpty() || this.waiters.isEmpty())) {
                this.waiters.peekFirst().signal();
            }
            this.lock.unlock();
            if (buffer == null) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
                return byteBuffer;
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private void freeUp(int size) {
        while (!this.free.isEmpty() && this.availableMemory < (long)size) {
            this.availableMemory += (long)this.free.pollLast().capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deallocate(ByteBuffer buffer, int size) {
        this.lock.lock();
        try {
            if (size == this.poolableSize && size == buffer.capacity()) {
                buffer.clear();
                this.free.add(buffer);
            } else {
                DirectBufferUtils.release(buffer);
                this.availableMemory += (long)size;
            }
            Condition moreMem = this.waiters.peekFirst();
            if (moreMem != null) {
                moreMem.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void deallocate(ByteBuffer buffer) {
        this.deallocate(buffer, buffer.capacity());
    }

    public long availableMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory + (long)(this.free.size() * this.poolableSize);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long unallocatedMemory() {
        this.lock.lock();
        try {
            long l = this.availableMemory;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int queued() {
        this.lock.lock();
        try {
            int n = this.waiters.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int poolableSize() {
        return this.poolableSize;
    }

    public long totalMemory() {
        return this.totalMemory;
    }
}

