/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.ByteBufferRequestContent;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import pl.allegro.tech.hermes.common.exception.InternalProcessingException;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.BatchHttpRequestFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;

public class DefaultBatchHttpRequestFactory
implements BatchHttpRequestFactory {
    private final HttpClient client;

    public DefaultBatchHttpRequestFactory(HttpClient client) {
        this.client = DefaultBatchHttpRequestFactory.started(client);
    }

    @Override
    public Request buildRequest(MessageBatch message, URI uri, HttpRequestHeaders headers, int requestTimeout) {
        return this.client.newRequest(uri).method(HttpMethod.POST).timeout((long)requestTimeout, TimeUnit.MILLISECONDS).body((Request.Content)new ByteBufferRequestContent(new ByteBuffer[]{message.getContent()})).headers(httpHeaders -> headers.asMap().forEach((arg_0, arg_1) -> ((HttpFields.Mutable)httpHeaders).add(arg_0, arg_1)));
    }

    private static HttpClient started(HttpClient httpClient) {
        try {
            httpClient.start();
            return httpClient;
        }
        catch (Exception e) {
            throw new InternalProcessingException("Failed to start http batch client", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.client.stop();
        }
        catch (Exception e) {
            throw new InternalProcessingException("Failed to stop http batch client", (Throwable)e);
        }
    }
}

