/* Generated SBE (Simple Binary Encoding) message codec. */
package pl.allegro.tech.hermes.consumers.supervisor.workload.sbe.stubs;

import org.agrona.MutableDirectBuffer;


/**
 * Consumer node load metrics
 */
@SuppressWarnings("all")
public final class ConsumerLoadEncoder
{
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 2;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ConsumerLoadEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public ConsumerLoadEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public ConsumerLoadEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int cpuUtilizationId()
    {
        return 1;
    }

    public static int cpuUtilizationSinceVersion()
    {
        return 0;
    }

    public static int cpuUtilizationEncodingOffset()
    {
        return 0;
    }

    public static int cpuUtilizationEncodingLength()
    {
        return 8;
    }

    public static String cpuUtilizationMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static double cpuUtilizationNullValue()
    {
        return Double.NaN;
    }

    public static double cpuUtilizationMinValue()
    {
        return 4.9E-324d;
    }

    public static double cpuUtilizationMaxValue()
    {
        return 1.7976931348623157E308d;
    }

    public ConsumerLoadEncoder cpuUtilization(final double value)
    {
        buffer.putDouble(offset + 0, value, BYTE_ORDER);
        return this;
    }


    private final SubscriptionsEncoder subscriptions = new SubscriptionsEncoder(this);

    public static long subscriptionsId()
    {
        return 2;
    }

    public SubscriptionsEncoder subscriptionsCount(final int count)
    {
        subscriptions.wrap(buffer, count);
        return subscriptions;
    }

    public static final class SubscriptionsEncoder
    {
        public static final int HEADER_SIZE = 4;
        private final ConsumerLoadEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        SubscriptionsEncoder(final ConsumerLoadEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 65534)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)16, BYTE_ORDER);
            buffer.putShort(limit + 2, (short)count, BYTE_ORDER);
        }

        public SubscriptionsEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putShort(initialLimit + 2, (short)count, BYTE_ORDER);

            return count;
        }

        public static int countMinValue()
        {
            return 0;
        }

        public static int countMaxValue()
        {
            return 65534;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 16;
        }

        public static int idId()
        {
            return 3;
        }

        public static int idSinceVersion()
        {
            return 0;
        }

        public static int idEncodingOffset()
        {
            return 0;
        }

        public static int idEncodingLength()
        {
            return 8;
        }

        public static String idMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long idNullValue()
        {
            return -9223372036854775808L;
        }

        public static long idMinValue()
        {
            return -9223372036854775807L;
        }

        public static long idMaxValue()
        {
            return 9223372036854775807L;
        }

        public SubscriptionsEncoder id(final long value)
        {
            buffer.putLong(offset + 0, value, BYTE_ORDER);
            return this;
        }


        public static int operationsPerSecondId()
        {
            return 4;
        }

        public static int operationsPerSecondSinceVersion()
        {
            return 0;
        }

        public static int operationsPerSecondEncodingOffset()
        {
            return 8;
        }

        public static int operationsPerSecondEncodingLength()
        {
            return 8;
        }

        public static String operationsPerSecondMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static double operationsPerSecondNullValue()
        {
            return Double.NaN;
        }

        public static double operationsPerSecondMinValue()
        {
            return 4.9E-324d;
        }

        public static double operationsPerSecondMaxValue()
        {
            return 1.7976931348623157E308d;
        }

        public SubscriptionsEncoder operationsPerSecond(final double value)
        {
            buffer.putDouble(offset + 8, value, BYTE_ORDER);
            return this;
        }

    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final ConsumerLoadDecoder decoder = new ConsumerLoadDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
