/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.batch.MessageBatch;
import pl.allegro.tech.hermes.consumers.consumer.sender.MessageSendingResult;
import pl.allegro.tech.hermes.metrics.HermesCounter;
import pl.allegro.tech.hermes.metrics.HermesHistogram;
import pl.allegro.tech.hermes.metrics.HermesTimer;

class BatchConsumerMetrics {
    private final MetricsFacade metrics;
    private final SubscriptionName subscriptionName;
    private final LongAdder inflightCount = new LongAdder();
    private final HermesCounter failures;
    private final HermesCounter timeouts;
    private final HermesCounter otherErrors;
    private final HermesCounter discarded;
    private final HermesHistogram inflightTime;
    private final HermesCounter throughputInBytes;
    private final HermesCounter successes;
    private final HermesCounter batchSuccesses;
    private final HermesTimer latency;
    private final Map<Integer, HermesCounter> httpStatusCodes = new ConcurrentHashMap<Integer, HermesCounter>();

    BatchConsumerMetrics(MetricsFacade metrics, SubscriptionName subscriptionName) {
        this.metrics = metrics;
        this.subscriptionName = subscriptionName;
        this.failures = metrics.subscriptions().failuresCounter(subscriptionName);
        this.timeouts = metrics.subscriptions().timeoutsCounter(subscriptionName);
        this.otherErrors = metrics.subscriptions().otherErrorsCounter(subscriptionName);
        this.discarded = metrics.subscriptions().discarded(subscriptionName);
        this.inflightTime = metrics.subscriptions().inflightTimeInMillisHistogram(subscriptionName);
        this.throughputInBytes = metrics.subscriptions().throughputInBytes(subscriptionName);
        this.successes = metrics.subscriptions().successes(subscriptionName);
        this.batchSuccesses = metrics.subscriptions().batchSuccesses(subscriptionName);
        this.latency = metrics.subscriptions().latency(subscriptionName);
    }

    void recordAttempt(int messageCount) {
        this.inflightCount.add(messageCount);
    }

    void recordAttemptAsFinished(int messageCount) {
        this.inflightCount.add(-1 * messageCount);
    }

    void markFailure(MessageBatch batch, MessageSendingResult result) {
        this.failures.increment();
        if (result.hasHttpAnswer()) {
            this.markHttpStatusCode(result.getStatusCode());
        } else if (result.isTimeout()) {
            this.timeouts.increment();
        } else {
            this.otherErrors.increment();
        }
        this.throughputInBytes.increment((long)batch.getSize());
    }

    void markSuccess(MessageBatch batch, MessageSendingResult result) {
        this.successes.increment((long)batch.getMessageCount());
        this.batchSuccesses.increment();
        this.throughputInBytes.increment((long)batch.getSize());
        this.markHttpStatusCode(result.getStatusCode());
        this.inflightTime.record(batch.getLifetime());
    }

    private void markHttpStatusCode(int statusCode) {
        this.httpStatusCodes.computeIfAbsent(statusCode, integer -> this.metrics.subscriptions().httpAnswerCounter(this.subscriptionName, statusCode)).increment();
    }

    void shutdown() {
        this.metrics.unregisterAllMetricsRelatedTo(this.subscriptionName);
    }

    void initialize() {
        this.metrics.subscriptions().registerInflightGauge(this.subscriptionName, (Object)this, metrics -> metrics.inflightCount.doubleValue());
    }

    void markDiscarded() {
        this.discarded.increment();
    }

    void markDiscarded(MessageBatch batch) {
        this.discarded.increment((long)batch.getMessageCount());
        this.inflightTime.record(batch.getLifetime());
    }

    HermesTimer latencyTimer() {
        return this.latency;
    }
}

