/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.rate.maxrate;

import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.common.metric.MetricsFacade;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.ConsumerRateInfo;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRate;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateBalancer;
import pl.allegro.tech.hermes.consumers.consumer.rate.maxrate.MaxRateRegistry;
import pl.allegro.tech.hermes.consumers.subscription.cache.SubscriptionsCache;
import pl.allegro.tech.hermes.consumers.supervisor.workload.ClusterAssignmentCache;

class MaxRateCalculator {
    private static final Logger logger = LoggerFactory.getLogger(MaxRateCalculator.class);
    private final ClusterAssignmentCache clusterAssignmentCache;
    private final SubscriptionsCache subscriptionsCache;
    private final MaxRateBalancer balancer;
    private final MaxRateRegistry maxRateRegistry;
    private final Clock clock;
    private volatile long lastUpdateDurationMillis = 0L;

    MaxRateCalculator(ClusterAssignmentCache clusterAssignmentCache, SubscriptionsCache subscriptionsCache, MaxRateBalancer balancer, MaxRateRegistry maxRateRegistry, MetricsFacade metrics, Clock clock) {
        this.clusterAssignmentCache = clusterAssignmentCache;
        this.subscriptionsCache = subscriptionsCache;
        this.balancer = balancer;
        this.maxRateRegistry = maxRateRegistry;
        this.clock = clock;
        metrics.maxRate().registerCalculationDurationInMillisGauge((Object)this, calculator -> calculator.lastUpdateDurationMillis);
    }

    void calculate() {
        try {
            logger.info("Max rate calculation started");
            long start = this.clock.millis();
            this.maxRateRegistry.onBeforeMaxRateCalculation();
            this.clusterAssignmentCache.getSubscriptionConsumers().forEach((subscriptionName, consumerIds) -> {
                try {
                    Subscription subscription = this.subscriptionsCache.getSubscription((SubscriptionName)subscriptionName);
                    if (!subscription.isBatchSubscription()) {
                        Set<ConsumerRateInfo> rateInfos = this.maxRateRegistry.ensureCorrectAssignments(subscription.getQualifiedName(), (Set<String>)consumerIds);
                        Optional<Map<String, MaxRate>> newRates = this.balancer.balance(subscription.getSerialSubscriptionPolicy().getRate().intValue(), rateInfos);
                        newRates.ifPresent(rates -> {
                            logger.debug("Calculated new max rates for {}: {}", (Object)subscription.getQualifiedName(), rates);
                            this.maxRateRegistry.update(subscription.getQualifiedName(), (Map<String, MaxRate>)rates);
                        });
                    }
                }
                catch (Exception e) {
                    logger.error("Problem calculating max rates for subscription {}", subscriptionName, (Object)e);
                }
            });
            this.maxRateRegistry.onAfterMaxRateCalculation();
            this.lastUpdateDurationMillis = this.clock.millis() - start;
            logger.info("Max rate calculation done in {} ms", (Object)this.lastUpdateDurationMillis);
        }
        catch (Exception e) {
            logger.error("Problem calculating max rate", (Throwable)e);
        }
    }
}

