/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.Constraints;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.api.TopicName;

public class WorkloadConstraints {
    private final int activeConsumerCount;
    private final int consumersPerSubscription;
    private final int maxSubscriptionsPerConsumer;
    private final Map<SubscriptionName, Constraints> subscriptionConstraints;
    private final Map<TopicName, Constraints> topicConstraints;

    private WorkloadConstraints(int activeConsumerCount, int consumersPerSubscription, int maxSubscriptionsPerConsumer, Map<SubscriptionName, Constraints> subscriptionConstraints, Map<TopicName, Constraints> topicConstraints) {
        this.activeConsumerCount = activeConsumerCount;
        this.consumersPerSubscription = consumersPerSubscription;
        this.maxSubscriptionsPerConsumer = maxSubscriptionsPerConsumer;
        this.subscriptionConstraints = subscriptionConstraints != null ? subscriptionConstraints : Collections.emptyMap();
        this.topicConstraints = topicConstraints != null ? topicConstraints : Collections.emptyMap();
    }

    public int getConsumerCount(SubscriptionName subscriptionName) {
        Constraints requiredConsumers = this.subscriptionConstraints.get(subscriptionName);
        if (requiredConsumers == null) {
            requiredConsumers = this.topicConstraints.get(subscriptionName.getTopicName());
        }
        if (requiredConsumers != null && requiredConsumers.getConsumersNumber() > 0) {
            return Math.min(requiredConsumers.getConsumersNumber(), this.activeConsumerCount);
        }
        return Math.min(this.consumersPerSubscription, this.activeConsumerCount);
    }

    public int getMaxSubscriptionsPerConsumer() {
        return this.maxSubscriptionsPerConsumer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int activeConsumerCount;
        private int consumersPerSubscription;
        private int maxSubscriptionsPerConsumer;
        private Map<SubscriptionName, Constraints> subscriptionConstraints = new HashMap<SubscriptionName, Constraints>();
        private Map<TopicName, Constraints> topicConstraints = new HashMap<TopicName, Constraints>();

        public Builder withActiveConsumers(int activeConsumerCount) {
            this.activeConsumerCount = activeConsumerCount;
            return this;
        }

        public Builder withConsumersPerSubscription(int consumersPerSubscription) {
            this.consumersPerSubscription = consumersPerSubscription;
            return this;
        }

        public Builder withMaxSubscriptionsPerConsumer(int maxSubscriptionsPerConsumer) {
            this.maxSubscriptionsPerConsumer = maxSubscriptionsPerConsumer;
            return this;
        }

        public Builder withSubscriptionConstraints(Map<SubscriptionName, Constraints> subscriptionConstraints) {
            this.subscriptionConstraints = subscriptionConstraints;
            return this;
        }

        public Builder withTopicConstraints(Map<TopicName, Constraints> topicConstraints) {
            this.topicConstraints = topicConstraints;
            return this;
        }

        public WorkloadConstraints build() {
            return new WorkloadConstraints(this.activeConsumerCount, this.consumersPerSubscription, this.maxSubscriptionsPerConsumer, this.subscriptionConstraints, this.topicConstraints);
        }
    }
}

