/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNodeLoad;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionProfiles;

public class CurrentLoadProvider {
    private final Map<String, ConsumerNodeLoad> consumerLoads = new ConcurrentHashMap<String, ConsumerNodeLoad>();
    private volatile SubscriptionProfiles profiles = SubscriptionProfiles.EMPTY;

    SubscriptionProfiles getProfiles() {
        return this.profiles;
    }

    ConsumerNodeLoad getConsumerNodeLoad(String consumerId) {
        return this.consumerLoads.getOrDefault(consumerId, ConsumerNodeLoad.UNDEFINED);
    }

    void updateConsumerNodeLoads(Map<String, ConsumerNodeLoad> newConsumerLoads) {
        this.consumerLoads.clear();
        this.consumerLoads.putAll(newConsumerLoads);
    }

    void updateProfiles(SubscriptionProfiles newProfiles) {
        this.profiles = newProfiles;
    }

    void clear() {
        this.consumerLoads.clear();
        this.profiles = SubscriptionProfiles.EMPTY;
    }
}

