/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.uri;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import pl.allegro.tech.hermes.consumers.uri.InvalidHostException;

public final class UriUtils {
    private UriUtils() {
    }

    public static String extractHostFromUri(URI uri) {
        return Optional.ofNullable(uri.getHost()).orElseThrow(() -> new InvalidHostException("Host name contains invalid chars. Underscore is one of them.")).replace("/", "");
    }

    public static Integer extractPortFromUri(URI uri) {
        return uri.getPort() > 0 ? Integer.valueOf(uri.getPort()) : null;
    }

    public static String extractAddressFromUri(URI uri) {
        Object address = UriUtils.extractHostFromUri(uri);
        if (uri.getPort() > 0) {
            address = (String)address + ":" + uri.getPort();
        }
        return address;
    }

    public static String extractUserNameFromUri(URI uri) {
        if (uri.getRawUserInfo() == null) {
            return null;
        }
        List<String> userInfoParts = UriUtils.splitUserInfo(uri);
        if (userInfoParts.isEmpty()) {
            return null;
        }
        return userInfoParts.get(0);
    }

    public static String extractPasswordFromUri(URI uri) {
        if (uri.getRawUserInfo() == null) {
            return null;
        }
        List<String> userInfoParts = UriUtils.splitUserInfo(uri);
        if (userInfoParts.size() <= 1) {
            return null;
        }
        return userInfoParts.get(1);
    }

    public static String extractContextFromUri(URI uri) {
        return StringUtils.substringAfter((String)uri.toString(), (String)uri.getAuthority());
    }

    public static String extractDestinationTopicFromUri(URI uri) {
        return uri.getPath().replace("/", "");
    }

    public static URI appendContext(URI uri, String context) {
        return URI.create(StringUtils.removeEnd((String)uri.toString(), (String)"/") + "/" + StringUtils.removeStart((String)context, (String)"/"));
    }

    private static List<String> splitUserInfo(URI uri) {
        return Splitter.on((String)":").splitToList((CharSequence)uri.getRawUserInfo());
    }
}

