/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang3.ArrayUtils;
import pl.allegro.tech.hermes.api.ContentType;
import pl.allegro.tech.hermes.api.Header;
import pl.allegro.tech.hermes.api.SubscriptionPolicy;
import pl.allegro.tech.hermes.common.kafka.KafkaTopicName;
import pl.allegro.tech.hermes.common.kafka.offset.PartitionOffset;
import pl.allegro.tech.hermes.domain.filtering.FilterableMessage;
import pl.allegro.tech.hermes.schema.CompiledSchema;

public class Message
implements FilterableMessage {
    private final String id;
    private final PartitionOffset partitionOffset;
    private final String topic;
    private final String subscription;
    private final boolean hasSubscriptionIdentityHeaders;
    private final ContentType contentType;
    private final Optional<CompiledSchema<Schema>> schema;
    private final long publishingTimestamp;
    private final long readingTimestamp;
    private final byte[] data;
    private int retryCounter = 0;
    private final long partitionAssignmentTerm;
    private final Map<String, String> externalMetadata;
    private final List<Header> additionalHeaders;
    private final Set<String> succeededUris = Sets.newHashSet();
    private long currentMessageBackoff = -1L;
    private boolean isFiltered = false;

    public Message(String id, String topic, byte[] content, ContentType contentType, Optional<CompiledSchema<Schema>> schema, long publishingTimestamp, long readingTimestamp, PartitionOffset partitionOffset, long partitionAssignmentTerm, Map<String, String> externalMetadata, List<Header> additionalHeaders, String subscription, boolean hasSubscriptionIdentityHeaders) {
        this.id = id;
        this.data = content;
        this.topic = topic;
        this.contentType = contentType;
        this.schema = schema;
        this.publishingTimestamp = publishingTimestamp;
        this.readingTimestamp = readingTimestamp;
        this.partitionOffset = partitionOffset;
        this.partitionAssignmentTerm = partitionAssignmentTerm;
        this.externalMetadata = ImmutableMap.copyOf(externalMetadata);
        this.additionalHeaders = ImmutableList.copyOf(additionalHeaders);
        this.subscription = subscription;
        this.hasSubscriptionIdentityHeaders = hasSubscriptionIdentityHeaders;
    }

    public long getPublishingTimestamp() {
        return this.publishingTimestamp;
    }

    public long getReadingTimestamp() {
        return this.readingTimestamp;
    }

    public long getOffset() {
        return this.partitionOffset.getOffset();
    }

    public long getPartitionAssignmentTerm() {
        return this.partitionAssignmentTerm;
    }

    public byte[] getData() {
        return this.data;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public int getPartition() {
        return this.partitionOffset.getPartition();
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isTtlExceeded(long ttlMillis) {
        long currentTimestamp = System.currentTimeMillis();
        return currentTimestamp > this.readingTimestamp + ttlMillis;
    }

    public synchronized void incrementRetryCounter(Collection<URI> succeededUris) {
        ++this.retryCounter;
        this.succeededUris.addAll(succeededUris.stream().map(URI::toString).toList());
    }

    public synchronized int getRetryCounter() {
        return this.retryCounter;
    }

    public Optional<CompiledSchema<Schema>> getSchema() {
        return this.schema;
    }

    public String getId() {
        return this.id;
    }

    public synchronized Set<String> getSucceededUris() {
        return this.succeededUris;
    }

    public Map<String, String> getExternalMetadata() {
        return this.externalMetadata;
    }

    public List<Header> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    public synchronized long updateAndGetCurrentMessageBackoff(SubscriptionPolicy subscriptionPolicy) {
        this.currentMessageBackoff = this.currentMessageBackoff == -1L ? (long)subscriptionPolicy.getMessageBackoff().intValue() : Math.min(subscriptionPolicy.getBackoffMaxIntervalMillis(), (long)((double)this.currentMessageBackoff * subscriptionPolicy.getBackoffMultiplier()));
        return this.currentMessageBackoff;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Message other = (Message)obj;
        return Objects.equals(this.id, other.id);
    }

    public static Builder message() {
        return new Builder();
    }

    public KafkaTopicName getKafkaTopic() {
        return this.partitionOffset.getTopic();
    }

    public PartitionOffset getPartitionOffset() {
        return this.partitionOffset;
    }

    public synchronized boolean hasNotBeenSentTo(String uri) {
        return !this.succeededUris.contains(uri);
    }

    public long getSize() {
        return ArrayUtils.getLength((Object)this.data);
    }

    public boolean hasSubscriptionIdentityHeaders() {
        return this.hasSubscriptionIdentityHeaders;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public synchronized boolean isFiltered() {
        return this.isFiltered;
    }

    public synchronized void setFiltered(boolean filtered) {
        this.isFiltered = filtered;
    }

    public static class Builder {
        private String id;
        private PartitionOffset partitionOffset;
        private String topic;
        private String subscription;
        private boolean hasSubscriptionIdentityHeaders;
        private ContentType contentType;
        private Optional<CompiledSchema<Schema>> schema;
        private long publishingTimestamp;
        private long readingTimestamp;
        private byte[] data;
        private long partitionAssignmentTerm = -1L;
        private Map<String, String> externalMetadata = Collections.emptyMap();
        private List<Header> additionalHeaders = Collections.emptyList();

        public Builder fromMessage(Message message) {
            this.id = message.getId();
            this.data = message.getData();
            this.contentType = message.getContentType();
            this.topic = message.getTopic();
            this.subscription = message.getSubscription();
            this.hasSubscriptionIdentityHeaders = message.hasSubscriptionIdentityHeaders();
            this.publishingTimestamp = message.getPublishingTimestamp();
            this.readingTimestamp = message.getReadingTimestamp();
            this.partitionOffset = message.partitionOffset;
            this.partitionAssignmentTerm = message.partitionAssignmentTerm;
            this.externalMetadata = message.getExternalMetadata();
            this.additionalHeaders = message.getAdditionalHeaders();
            this.schema = message.getSchema();
            return this;
        }

        public Builder withData(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder withSchema(CompiledSchema<Schema> schema) {
            this.schema = Optional.of(schema);
            return this;
        }

        public Builder withExternalMetadata(Map<String, String> externalMetadata) {
            this.externalMetadata = ImmutableMap.copyOf(externalMetadata);
            return this;
        }

        public Builder withAdditionalHeaders(List<Header> additionalHeaders) {
            this.additionalHeaders = ImmutableList.copyOf(additionalHeaders);
            return this;
        }

        public Builder withContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withNoSchema() {
            this.schema = Optional.empty();
            return this;
        }

        public Message build() {
            return new Message(this.id, this.topic, this.data, this.contentType, this.schema, this.publishingTimestamp, this.readingTimestamp, this.partitionOffset, this.partitionAssignmentTerm, this.externalMetadata, this.additionalHeaders, this.subscription, this.hasSubscriptionIdentityHeaders);
        }
    }
}

