/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.idletime;

import com.google.common.base.Preconditions;
import pl.allegro.tech.hermes.consumers.consumer.idletime.IdleTimeCalculator;

public class ExponentiallyGrowingIdleTimeCalculator
implements IdleTimeCalculator {
    private final long base;
    private final long initialIdleTimeMs;
    private final long maxIdleTimeMs;
    private long currentIdleTimeMs;

    public ExponentiallyGrowingIdleTimeCalculator(long initialIdleTimeMs, long maxIdleTimeMs) {
        this(2L, initialIdleTimeMs, maxIdleTimeMs);
    }

    public ExponentiallyGrowingIdleTimeCalculator(long base, long initialIdleTime, long maxIdleTimeMs) {
        Preconditions.checkArgument((base > 0L ? 1 : 0) != 0, (Object)"base should be greater than zero");
        Preconditions.checkArgument((initialIdleTime > 0L ? 1 : 0) != 0, (Object)"initialIdleTimeMs should be greater than zero");
        Preconditions.checkArgument((maxIdleTimeMs > 0L ? 1 : 0) != 0, (Object)"maxIdleTimeMs should be greater than zero");
        Preconditions.checkArgument((initialIdleTime <= maxIdleTimeMs ? 1 : 0) != 0, (Object)"maxIdleTimeMs should be grater or equal initialIdleTimeMs");
        this.base = base;
        this.initialIdleTimeMs = initialIdleTime;
        this.maxIdleTimeMs = maxIdleTimeMs;
        this.currentIdleTimeMs = initialIdleTime;
    }

    @Override
    public long increaseIdleTime() {
        long previousIdleTime = this.currentIdleTimeMs;
        this.currentIdleTimeMs = Math.min(this.currentIdleTimeMs * this.base, this.maxIdleTimeMs);
        return previousIdleTime;
    }

    @Override
    public long getIdleTime() {
        return this.currentIdleTimeMs;
    }

    @Override
    public void reset() {
        this.currentIdleTimeMs = this.initialIdleTimeMs;
    }
}

