/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.http.headers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.http.HttpHeader;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.HttpRequestData;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.auth.HttpAuthorizationProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpHeadersProvider;
import pl.allegro.tech.hermes.consumers.consumer.sender.http.headers.HttpRequestHeaders;

public final class AuthHeadersProvider
implements HttpHeadersProvider {
    private final HttpHeadersProvider headersProvider;
    private final HttpAuthorizationProvider authorizationProvider;

    public AuthHeadersProvider(HttpHeadersProvider headersProvider, HttpAuthorizationProvider authorizationProvider) {
        this.headersProvider = headersProvider;
        this.authorizationProvider = authorizationProvider;
    }

    @Override
    public HttpRequestHeaders getHeaders(Message message, HttpRequestData requestData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (this.headersProvider != null) {
            builder.putAll(this.headersProvider.getHeaders(message, requestData).asMap());
        }
        if (this.authorizationProvider != null) {
            Optional<String> token = this.authorizationProvider.authorizationToken();
            token.ifPresent(s -> builder.put((Object)HttpHeader.AUTHORIZATION.toString(), s));
        }
        return new HttpRequestHeaders((Map<String, String>)builder.build());
    }
}

