/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.process;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import pl.allegro.tech.hermes.api.SubscriptionName;

public class Signal {
    private final SignalType type;
    private final SubscriptionName target;
    private final Object payload;
    private final long executeAfterTimestamp;
    private final long id;
    private static final AtomicLong SIGNALS_COUNTER = new AtomicLong();

    private Signal(SignalType type, SubscriptionName target, Object payload, long executeAfterTimestamp, long id) {
        this.type = type;
        this.target = target;
        this.payload = payload;
        this.executeAfterTimestamp = executeAfterTimestamp;
        this.id = id;
    }

    public static Signal of(SignalType type, SubscriptionName target) {
        return Signal.of(type, target, null);
    }

    public static Signal of(SignalType type, SubscriptionName target, Object payload) {
        return Signal.of(type, target, payload, -1L);
    }

    public static Signal of(SignalType type, SubscriptionName target, Object payload, long executeAfterTimestamp) {
        return new Signal(type, target, payload, executeAfterTimestamp, SIGNALS_COUNTER.incrementAndGet());
    }

    Signal createChild(SignalType type) {
        return new Signal(type, this.target, this.payload, this.executeAfterTimestamp, this.id);
    }

    SignalType getType() {
        return this.type;
    }

    SubscriptionName getTarget() {
        return this.target;
    }

    boolean canExecuteNow(long currentTimestamp) {
        return currentTimestamp >= this.executeAfterTimestamp;
    }

    <T> T getPayload() {
        return (T)this.payload;
    }

    public String toString() {
        return "Signal(" + this.id + ", " + this.type + ", " + this.target + ")";
    }

    public String getLogWithIdAndType() {
        return "[Signal(" + this.id + ", " + this.type + ")]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Signal)) {
            return false;
        }
        Signal signal = (Signal)o;
        return this.type == signal.type && Objects.equals(this.target, signal.target);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.target});
    }

    public static enum SignalType {
        START,
        STOP,
        RETRANSMIT,
        UPDATE_SUBSCRIPTION,
        UPDATE_TOPIC;

    }
}

