/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.Map;
import pl.allegro.tech.hermes.api.SubscriptionName;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.SubscriptionLoad;

class ConsumerNodeLoad {
    static final ConsumerNodeLoad UNDEFINED = new ConsumerNodeLoad(-1.0, Map.of());
    private final double cpuUtilization;
    private final Map<SubscriptionName, SubscriptionLoad> loadPerSubscription;

    ConsumerNodeLoad(double cpuUtilization, Map<SubscriptionName, SubscriptionLoad> loadPerSubscription) {
        this.cpuUtilization = cpuUtilization;
        this.loadPerSubscription = loadPerSubscription;
    }

    Map<SubscriptionName, SubscriptionLoad> getLoadPerSubscription() {
        return this.loadPerSubscription;
    }

    double getCpuUtilization() {
        return this.cpuUtilization;
    }

    double sumOperationsPerSecond() {
        return this.loadPerSubscription.values().stream().mapToDouble(SubscriptionLoad::getOperationsPerSecond).sum();
    }

    boolean isDefined() {
        return this.cpuUtilization != UNDEFINED.getCpuUtilization();
    }
}

