/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.interpolation;

import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.VariableExpansionException;
import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import pl.allegro.tech.hermes.api.EndpointAddress;
import pl.allegro.tech.hermes.consumers.consumer.Message;
import pl.allegro.tech.hermes.consumers.consumer.interpolation.InterpolationException;
import pl.allegro.tech.hermes.consumers.consumer.interpolation.UriInterpolator;

public class MessageBodyInterpolator
implements UriInterpolator {
    private static final int MAX_CACHE_SIZE = 1000;
    private final LoadingCache<String, UriTemplate> templateCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new TemplateLoader());
    private final LoadingCache<String, JsonPath> variableCompiler = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new JsonPathLoader());

    @Override
    public URI interpolate(EndpointAddress endpoint, Message message) throws InterpolationException {
        UriTemplate template = (UriTemplate)this.templateCache.getUnchecked((Object)endpoint.getEndpoint());
        String[] variables = template.getVariables();
        if (variables.length > 0) {
            HashMap values = Maps.newHashMap();
            String payload = new String(message.getData(), Charsets.UTF_8);
            for (String variable : variables) {
                JsonPath path = (JsonPath)this.variableCompiler.getUnchecked((Object)variable);
                try {
                    values.put(variable, path.read(payload));
                }
                catch (InvalidPathException e) {
                    throw new InterpolationException(String.format("Missing variable on path %s", path.getPath()), e);
                }
            }
            try {
                return URI.create(template.expand((Map)values));
            }
            catch (VariableExpansionException e) {
                throw new InterpolationException("Cannot expand template", e);
            }
        }
        return endpoint.getUri();
    }

    private static class TemplateLoader
    extends CacheLoader<String, UriTemplate> {
        private TemplateLoader() {
        }

        public UriTemplate load(String url) throws Exception {
            return UriTemplate.fromTemplate((String)url);
        }
    }

    private static class JsonPathLoader
    extends CacheLoader<String, JsonPath> {
        private static final String ROOT_PREFIX = "$.";

        private JsonPathLoader() {
        }

        public JsonPath load(String key) throws Exception {
            return JsonPath.compile((String)(ROOT_PREFIX + key), (Predicate[])new Predicate[0]);
        }
    }
}

