/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.CompressionCodec;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.CompressionCodecFactory;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageTransformer;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageTransformerCompression;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMessageTransformerRaw;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMetadataAppender;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubMetadataCompressionAppender;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.GooglePubSubSenderTarget;
import pl.allegro.tech.hermes.consumers.consumer.sender.googlepubsub.MessageCompressor;

public class GooglePubSubMessageTransformerCreator {
    private boolean compressionEnabled;
    private Long compressionThresholdBytes;
    private CompressionCodecFactory.CompressionLevel compressionLevel;
    private final GooglePubSubMessageTransformerRaw messageRawTransformer = new GooglePubSubMessageTransformerRaw(new GooglePubSubMetadataAppender());
    private static final Logger logger = LoggerFactory.getLogger(GooglePubSubMessageTransformerCreator.class);

    public static GooglePubSubMessageTransformerCreator creator() {
        return new GooglePubSubMessageTransformerCreator();
    }

    private GooglePubSubMessageTransformerCreator() {
    }

    public GooglePubSubMessageTransformerCreator withCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public GooglePubSubMessageTransformerCreator withCompressionLevel(String compressionLevel) {
        try {
            this.compressionLevel = Optional.ofNullable(compressionLevel).map(String::toUpperCase).map(CompressionCodecFactory.CompressionLevel::valueOf).orElse(CompressionCodecFactory.CompressionLevel.MEDIUM);
        }
        catch (IllegalArgumentException ex) {
            logger.warn("Unsupported compression level: {}, setting it to default", (Object)compressionLevel);
            this.compressionLevel = CompressionCodecFactory.CompressionLevel.MEDIUM;
        }
        return this;
    }

    public GooglePubSubMessageTransformerCreator withCompressionThresholdBytes(Long compressionThresholdBytes) {
        this.compressionThresholdBytes = compressionThresholdBytes;
        return this;
    }

    GooglePubSubMessageTransformer getTransformerForTargetEndpoint(GooglePubSubSenderTarget pubSubTarget) {
        if (this.compressionEnabled && pubSubTarget.isCompressionRequested()) {
            Optional<GooglePubSubMessageTransformer> compressingTransformer = this.transformerForCodec(pubSubTarget.getCompressionCodec());
            if (compressingTransformer.isPresent()) {
                return compressingTransformer.get();
            }
            logger.warn("Unsupported codec, switching to raw transfer for {}.", (Object)pubSubTarget.getTopicName());
        }
        return this.messageRawTransformer;
    }

    private Optional<GooglePubSubMessageTransformer> transformerForCodec(CompressionCodec codec) {
        return Optional.ofNullable(codec).map(it -> CompressionCodecFactory.of(it, this.compressionLevel)).map(codecFactory -> new GooglePubSubMessageTransformerCompression(this.compressionThresholdBytes, this.messageRawTransformer, new GooglePubSubMetadataCompressionAppender(codec), new MessageCompressor((CompressionCodecFactory)codecFactory)));
    }
}

