/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.consumer.receiver.kafka;

import com.google.common.primitives.Ints;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import pl.allegro.tech.hermes.common.kafka.HTTPHeadersPropagationAsKafkaHeadersProperties;
import pl.allegro.tech.hermes.common.message.wrapper.AvroMetadataMarker;
import pl.allegro.tech.hermes.consumers.config.KafkaHeaderNameProperties;

public class KafkaHeaderExtractor {
    private final KafkaHeaderNameProperties kafkaHeaderNameProperties;
    private final boolean isHTTPheadersPropagationAsKafkaHeadersEnabled;
    private final String httpHeadersPrefix;

    public KafkaHeaderExtractor(KafkaHeaderNameProperties kafkaHeaderNameProperties, HTTPHeadersPropagationAsKafkaHeadersProperties httpHeadersPropagationAsKafkaHeadersProperties) {
        this.kafkaHeaderNameProperties = kafkaHeaderNameProperties;
        this.isHTTPheadersPropagationAsKafkaHeadersEnabled = httpHeadersPropagationAsKafkaHeadersProperties.isEnabled();
        this.httpHeadersPrefix = httpHeadersPropagationAsKafkaHeadersProperties.getPrefix();
    }

    public Integer extractSchemaVersion(Headers headers) {
        Header header = headers.lastHeader(this.kafkaHeaderNameProperties.getSchemaVersion());
        return this.extract(header);
    }

    public Integer extractSchemaId(Headers headers) {
        Header header = headers.lastHeader(this.kafkaHeaderNameProperties.getSchemaId());
        return this.extract(header);
    }

    private Integer extract(Header header) {
        if (header != null) {
            return Ints.fromByteArray((byte[])header.value());
        }
        return null;
    }

    public String extractMessageId(Headers headers) {
        Header header = headers.lastHeader(this.kafkaHeaderNameProperties.getMessageId());
        if (header == null) {
            return "";
        }
        return new String(header.value(), StandardCharsets.UTF_8);
    }

    public Map<String, String> extractExternalMetadata(Headers headers, Map<String, String> defaultExternalMetadata) {
        if (this.isHTTPheadersPropagationAsKafkaHeadersEnabled) {
            Map<String, String> httpHeaders = StreamSupport.stream(headers.spliterator(), false).filter(h -> h.key().startsWith(this.httpHeadersPrefix)).collect(Collectors.toMap(h -> h.key().substring(this.httpHeadersPrefix.length()), h -> new String(h.value(), StandardCharsets.UTF_8)));
            if (httpHeaders.isEmpty()) {
                return defaultExternalMetadata;
            }
            HashMap<String, String> externalMetadata = new HashMap<String, String>(httpHeaders);
            externalMetadata.put(AvroMetadataMarker.METADATA_MESSAGE_ID_KEY.toString(), this.extractMessageId(headers));
            return externalMetadata;
        }
        return defaultExternalMetadata;
    }
}

