/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.consumers.supervisor.workload.weighted;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.ConsumerNode;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.TargetWeightCalculator;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.Weight;
import pl.allegro.tech.hermes.consumers.supervisor.workload.weighted.WeightedWorkloadMetricsReporter;

public class AvgTargetWeightCalculator
implements TargetWeightCalculator {
    private final WeightedWorkloadMetricsReporter metrics;

    public AvgTargetWeightCalculator(WeightedWorkloadMetricsReporter metrics) {
        this.metrics = metrics;
    }

    @Override
    public Map<String, Weight> calculate(Collection<ConsumerNode> consumers) {
        if (consumers.isEmpty()) {
            return Map.of();
        }
        this.metrics.reportCurrentWeights(consumers);
        Weight sum = consumers.stream().map(ConsumerNode::getWeight).reduce(Weight.ZERO, Weight::add);
        Weight average = sum.divide(consumers.size());
        Map<String, Weight> newWeights = consumers.stream().collect(Collectors.toMap(ConsumerNode::getConsumerId, ignore -> average));
        this.metrics.reportProposedWeights(newWeights);
        return newWeights;
    }
}

