/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api.auth;

import javax.ws.rs.container.ContainerRequestContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.management.api.auth.SecurityProvider;

@Component
public class ManagementRights {
    private final TopicRepository topicRepository;

    @Autowired
    public ManagementRights(TopicRepository topicRepository) {
        this.topicRepository = topicRepository;
    }

    public boolean isUserAllowedToManageTopic(Topic topic, ContainerRequestContext requestContext) {
        return requestContext.getSecurityContext().isUserInRole("admin") || this.getOwnershipResolver(requestContext).isUserAnOwner(topic.getOwner());
    }

    public boolean isUserAllowedToManageSubscription(Subscription subscription, ContainerRequestContext requestContext) {
        return requestContext.getSecurityContext().isUserInRole("admin") || this.getOwnershipResolver(requestContext).isUserAnOwner(this.topicRepository.getTopicDetails(subscription.getTopicName()).getOwner()) || this.getOwnershipResolver(requestContext).isUserAnOwner(subscription.getOwner());
    }

    private SecurityProvider.OwnershipResolver getOwnershipResolver(ContainerRequestContext requestContext) {
        return (SecurityProvider.OwnershipResolver)requestContext.getProperty("ownership-resolver");
    }
}

