/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.subscription.health.problem;

import pl.allegro.tech.hermes.api.Subscription;
import pl.allegro.tech.hermes.api.SubscriptionHealth;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionHealthContext;
import pl.allegro.tech.hermes.management.domain.subscription.health.SubscriptionMetrics;
import pl.allegro.tech.hermes.management.domain.subscription.health.problem.AbstractSubscriptionHealthProblemIndicator;

public class ReceivingMalformedMessagesIndicator
extends AbstractSubscriptionHealthProblemIndicator {
    private final double max4xxErrorsRatio;
    private final double minSubscriptionRateForReliableMetrics;

    public ReceivingMalformedMessagesIndicator(double max4xxErrorsRatio, double minSubscriptionRateForReliableMetrics) {
        this.max4xxErrorsRatio = max4xxErrorsRatio;
        this.minSubscriptionRateForReliableMetrics = minSubscriptionRateForReliableMetrics;
    }

    @Override
    public boolean problemOccurs(SubscriptionHealthContext context) {
        Subscription subscription = context.getSubscription();
        SubscriptionMetrics subscriptionMetrics = context.getSubscriptionMetrics();
        return this.hasClientErrorRetry(subscription) && this.areSubscriptionMetricsReliable(subscriptionMetrics) && this.isCode4xxErrorsRateHigh(subscriptionMetrics);
    }

    private boolean hasClientErrorRetry(Subscription subscription) {
        if (subscription.isBatchSubscription()) {
            return subscription.getBatchSubscriptionPolicy().isRetryClientErrors();
        }
        return subscription.getSerialSubscriptionPolicy().isRetryClientErrors();
    }

    private boolean areSubscriptionMetricsReliable(SubscriptionMetrics subscriptionMetrics) {
        return subscriptionMetrics.getRate() > this.minSubscriptionRateForReliableMetrics;
    }

    private boolean isCode4xxErrorsRateHigh(SubscriptionMetrics subscriptionMetrics) {
        double rate;
        double code4xxErrorsRate = subscriptionMetrics.getCode4xxErrorsRate();
        return code4xxErrorsRate > this.max4xxErrorsRatio * (rate = subscriptionMetrics.getRate());
    }

    @Override
    public SubscriptionHealth.Problem getProblem() {
        return SubscriptionHealth.Problem.RECEIVING_MALFORMED_MESSAGES;
    }
}

