/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.domain.topic;

import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.PatchData;
import pl.allegro.tech.hermes.api.Query;
import pl.allegro.tech.hermes.api.Topic;
import pl.allegro.tech.hermes.api.TopicMetrics;
import pl.allegro.tech.hermes.api.TopicName;
import pl.allegro.tech.hermes.api.helpers.Patch;
import pl.allegro.tech.hermes.domain.topic.TopicRepository;
import pl.allegro.tech.hermes.domain.topic.preview.MessagePreviewRepository;
import pl.allegro.tech.hermes.management.config.TopicProperties;
import pl.allegro.tech.hermes.management.domain.Auditor;
import pl.allegro.tech.hermes.management.domain.group.GroupService;
import pl.allegro.tech.hermes.management.domain.topic.CreatorRights;
import pl.allegro.tech.hermes.management.domain.topic.TopicContentTypeMigrationService;
import pl.allegro.tech.hermes.management.domain.topic.TopicMetricsRepository;
import pl.allegro.tech.hermes.management.domain.topic.TopicRemovalDisabledException;
import pl.allegro.tech.hermes.management.domain.topic.validator.TopicValidator;
import pl.allegro.tech.hermes.management.infrastructure.kafka.MultiDCAwareService;

@Component
public class TopicService {
    private static final Logger logger = LoggerFactory.getLogger(TopicService.class);
    private final boolean allowRemoval;
    private final TopicRepository topicRepository;
    private final GroupService groupService;
    private final TopicMetricsRepository metricRepository;
    private final MessagePreviewRepository messagePreviewRepository;
    private final MultiDCAwareService multiDCAwareService;
    private final TopicValidator topicValidator;
    private final TopicContentTypeMigrationService topicContentTypeMigrationService;
    private final Clock clock;
    private final Auditor auditor;

    @Autowired
    public TopicService(MultiDCAwareService multiDCAwareService, TopicRepository topicRepository, GroupService groupService, TopicProperties topicProperties, TopicMetricsRepository metricRepository, TopicValidator topicValidator, TopicContentTypeMigrationService topicContentTypeMigrationService, MessagePreviewRepository messagePreviewRepository, Clock clock, Auditor auditor) {
        this.multiDCAwareService = multiDCAwareService;
        this.allowRemoval = topicProperties.isAllowRemoval();
        this.topicRepository = topicRepository;
        this.groupService = groupService;
        this.metricRepository = metricRepository;
        this.topicValidator = topicValidator;
        this.topicContentTypeMigrationService = topicContentTypeMigrationService;
        this.messagePreviewRepository = messagePreviewRepository;
        this.clock = clock;
        this.auditor = auditor;
    }

    public void createTopic(Topic topic, String createdBy, CreatorRights creatorRights) {
        this.topicValidator.ensureCreatedTopicIsValid(topic, creatorRights);
        this.topicRepository.createTopic(topic);
        if (!this.multiDCAwareService.topicExists(topic)) {
            this.createTopicInBrokers(topic);
            this.auditor.objectCreated(createdBy, topic);
        } else {
            logger.info("Skipping creation of topic {} on brokers, topic already exists", (Object)topic.getQualifiedName());
        }
    }

    private void createTopicInBrokers(Topic topic) {
        try {
            this.multiDCAwareService.manageTopic(brokerTopicManagement -> brokerTopicManagement.createTopic(topic));
        }
        catch (Exception exception) {
            logger.error(String.format("Could not create topic %s, rollback topic creation.", topic.getQualifiedName()), (Throwable)exception);
            this.topicRepository.removeTopic(topic.getName());
        }
    }

    public void removeTopic(Topic topic, String removedBy) {
        if (!this.allowRemoval) {
            throw new TopicRemovalDisabledException(topic);
        }
        this.topicRepository.removeTopic(topic.getName());
        this.multiDCAwareService.manageTopic(brokerTopicManagement -> brokerTopicManagement.removeTopic(topic));
        this.auditor.objectRemoved(removedBy, Topic.class.getSimpleName(), topic.getQualifiedName());
    }

    public void updateTopic(TopicName topicName, PatchData patch, String modifiedBy) {
        this.groupService.checkGroupExists(topicName.getGroupName());
        Topic retrieved = this.getTopicDetails(topicName);
        Topic modified = (Topic)Patch.apply((Object)retrieved, (PatchData)patch);
        this.topicValidator.ensureUpdatedTopicIsValid(modified, retrieved);
        if (!retrieved.equals((Object)modified)) {
            Instant beforeMigrationInstant = this.clock.instant();
            if (retrieved.getRetentionTime() != modified.getRetentionTime()) {
                this.multiDCAwareService.manageTopic(brokerTopicManagement -> brokerTopicManagement.updateTopic(modified));
            }
            this.topicRepository.updateTopic(modified);
            if (!retrieved.wasMigratedFromJsonType() && modified.wasMigratedFromJsonType()) {
                this.topicContentTypeMigrationService.notifySubscriptions(modified, beforeMigrationInstant);
            }
            this.auditor.objectUpdated(modifiedBy, retrieved, modified);
        }
    }

    public void touchTopic(TopicName topicName) {
        this.topicRepository.touchTopic(topicName);
    }

    public List<String> listQualifiedTopicNames(String groupName) {
        return this.topicRepository.listTopicNames(groupName).stream().map(topicName -> new TopicName(groupName, topicName).qualifiedName()).collect(Collectors.toList());
    }

    public List<Topic> listTopics(String groupName) {
        return this.topicRepository.listTopics(groupName);
    }

    public List<String> listQualifiedTopicNames() {
        return this.groupService.listGroupNames().stream().map(this::listQualifiedTopicNames).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public Topic getTopicDetails(TopicName topicName) {
        return this.topicRepository.getTopicDetails(topicName);
    }

    public TopicMetrics getTopicMetrics(TopicName topicName) {
        return this.topicRepository.topicExists(topicName) ? this.metricRepository.loadMetrics(topicName) : TopicMetrics.unavailable();
    }

    public String fetchSingleMessageFromPrimary(String brokersClusterName, TopicName topicName, Integer partition, Long offset) {
        return this.multiDCAwareService.readMessageFromPrimary(brokersClusterName, this.getTopicDetails(topicName), partition, offset);
    }

    public List<String> listTrackedTopicNames() {
        return this.groupService.listGroupNames().stream().map(arg_0 -> ((TopicRepository)this.topicRepository).listTopics(arg_0)).flatMap(Collection::stream).filter(Topic::isTrackingEnabled).map(Topic::getQualifiedName).collect(Collectors.toList());
    }

    public List<String> listTrackedTopicNames(String groupName) {
        return this.listTopics(groupName).stream().filter(Topic::isTrackingEnabled).map(Topic::getQualifiedName).collect(Collectors.toList());
    }

    public List<String> listFilteredTopicNames(Query<Topic> query) {
        return this.queryTopic(query).stream().map(Topic::getQualifiedName).collect(Collectors.toList());
    }

    public List<String> listFilteredTopicNames(String groupName, Query<Topic> query) {
        return query.filter(this.listTopics(groupName)).map(Topic::getQualifiedName).collect(Collectors.toList());
    }

    public List<Topic> queryTopic(Query<Topic> query) {
        return query.filter(this.getAllTopics()).collect(Collectors.toList());
    }

    public List<Topic> getAllTopics() {
        return this.groupService.listGroupNames().stream().map(arg_0 -> ((TopicRepository)this.topicRepository).listTopics(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Optional<byte[]> preview(TopicName topicName, int idx) {
        List result = this.messagePreviewRepository.loadPreview(topicName);
        if (idx >= 0 && idx < result.size()) {
            return Optional.of(result.get(idx));
        }
        return Optional.empty();
    }

    public List<String> previewText(TopicName topicName) {
        List result = this.messagePreviewRepository.loadPreview(topicName);
        ArrayList<String> response = new ArrayList<String>(result.size());
        for (byte[] r : result) {
            response.add(new String(r, StandardCharsets.UTF_8));
        }
        return response;
    }
}

