/*
 * Decompiled with CFR 0.152.
 */
package pl.allegro.tech.hermes.management.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.allegro.tech.hermes.api.Owner;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSource;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSourceNotFound;
import pl.allegro.tech.hermes.management.domain.owner.OwnerSources;

@Component
@Path(value="/owners")
@Api(value="/owners", description="Provides owners information")
public class OwnersEndpoint {
    private final OwnerSources ownerSources;

    @Autowired
    public OwnersEndpoint(OwnerSources ownerSources) {
        this.ownerSources = ownerSources;
    }

    @GET
    @Path(value="/sources/{source}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists owners from the given source matching the search string", response=List.class, httpMethod="GET")
    public List<Owner> search(@PathParam(value="source") String source, @QueryParam(value="search") String searchString) {
        return this.ownerSources.getAutocompletionFor(source).ownersMatching(searchString);
    }

    @GET
    @Path(value="/sources/{source}/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns owner from the given source of the given id", response=List.class, httpMethod="GET")
    public Owner get(@PathParam(value="source") String source, @PathParam(value="id") String id) {
        return this.ownerSources.getByName(source).map(s -> s.get(id)).orElseThrow(() -> new OwnerSourceNotFound(source));
    }

    @GET
    @Path(value="/sources")
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists owner sources", response=List.class, httpMethod="GET")
    public List<SourceDescriptor> listSources() {
        return StreamSupport.stream(this.ownerSources.spliterator(), false).map(SourceDescriptor::of).collect(Collectors.toList());
    }

    private static class SourceDescriptor {
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="autocomplete")
        private final boolean autocomplete;

        private SourceDescriptor(OwnerSource source) {
            this.name = source.name();
            this.autocomplete = source.autocompletion().isPresent();
        }

        static SourceDescriptor of(OwnerSource source) {
            return new SourceDescriptor(source);
        }
    }
}

